#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI index.cgi,v 1.5 1996/10/11 20:55:42 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::System::Calendar;
require HTML::Markup::HTML2;
require HTML::Markup::Cal;
require FileFormat::Calendar;

use AdminWEB::Support;
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    my ($sec, $min, $hour, $mday, $mon, $yr, $wday, $yday, $isdst)
	= localtime(time);
    $year = $cgi->param('year');
    $year = $yr+1900 unless defined $year && $year ne '';
    $month = $cgi->param('month');
    $month = $mon+1 unless defined $month && $month ne '';

    # generate forward and back pointers
    my $nextm = $month+1;
    my $nexty = $year; $nexty = $year+1 if $nextm > 12;
    my $prevm = $month-1;
    my $prevy = $year; $prevy = $year-1 if $prevm < 1;
    # clip month
    $nextm = 1 if $nextm > 12;
    $prevm = 12 if $prevm < 1;

    my $nm = qq{<B><A HREF="?month=$nextm\&year=$nexty">Next</A></B>\n};
    my $pm = qq{<B><A HREF="?month=$prevm\&year=$prevy">Prev</A></B>\n};

    # read the system calendar file (if any)
    $calendar = Create FileFormat::Calendar('./calendar');
    # $calendar->readfile('./calendar');
    # $calendar->entry("manual calendar entry example");

    $cal = Create HTML::Markup::Cal ($month, $year, $calendar->msg);
    # $cal->entry(10, "...");		# add entries in the calendar

    $html = Create HTML::Markup::HTML2;
    $html->HEAD->TITLE->Text("Calendar $month $year");
    $body = $html->BODY;
    my $table = $body->TABLE->width('100%')->border(0);
    my $tr = $table->TR;
    $tr->TH->Literal($pm);
    $tr->TH->Literal($nm);

    $body->append($cal);

    print $html->realize;			# renders the entire structure

    exit(0);
}
