#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.11 1996/12/17 21:35:46 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::System::Date;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$prop_file: Permission denied\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("Status: Set System Date/Time");

    ### PROCESS CGI DATA

    # require './initialize.pl';
    # Initialize();

    my $date;

    # verify date string format
    if (defined($date = $cgi->param('date'))) {
	# this lets you set the date "manually".
	$stat->error("Invalid Date String")
	    unless $date =~ m/^(\d\d){1,5}(\.\d\d)?$/;
    }
    else {
	my ($year, $month, $day, $hour, $minute, $second);
	$year = $cgi->param('year');
	$stat->error("Invalid year: $year")
	   unless $year > 1969;
	$year %= 100;			# 00 is 2000, this works until 2069

	# month names to month number
	%months = (
	    qw(Jan 1 Feb 2 Mar 3 Apr 4 May 5 Jun 6),
	    qw(Jul 7 Aug 8 Sep 9 Oct 10 Nov 11 Dec 12),
	);
	$month = $cgi->param('month');
	$stat->error("Invalid month: $month")
	    unless exists $months{$month};
	$month = $months{$month};

	$day = $cgi->param('day');
	$stat->error("Invalid day: $day")
	    unless $day > 0 && $day < 32;

	$hour = $cgi->param('hour');
	$stat->error("Invalid hour: $hour")
	    unless $hour >= 0 && $hour < 24;

	$minute = $cgi->param('minute');
	$stat->error("Invalid minute: $minute")
	    unless $minute >= 0 && $minute < 60;

	$second = $cgi->param('second');
	$stat->error("Invalid second: $second")
	    unless $second >= 0 && $second < 60;

	$date = sprintf("%02d%02d%02d%02d%02d.%02d",
	    $year, $month, $day, $hour, $minute, $second);
    }

    # $stat->warning('Are You Sure?');

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("Error(s) in Form Data");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("Warning(s): Requires Confirmation",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("Form Data Verified OK");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B>$cgi\n";
	return;
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    ### run the command
    my ($status, $output);
    if ($navigator->value('Demo')) {
	# just show what we would have done
	($status, $output) = (0, ["$_PATH_DATE $date"]);
    }
    else {
	($status, $output) = run_backend($_PATH_DATE, '-n', $date);
    }

    if ($status != 0) {
	$stat->Report("Error Executing Command", $output);
    }
    else {
	push(@$output, "Local date and time: " . `$_PATH_DATE` . "<BR>");
	push(@$output, nextphase($cgi)) if initmode($cgi);
	$stat->Report("Command Successful", $output, 'literal');
    }

    print $stat->HTML;
}
