#!/usr/bin/perl5
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI View.cgi,v 1.11 1996/10/11 20:55:47 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package SysAdmin::System::Shutdown;

use AdminWEB::Support;		# imports support routines
use AdminWEB::Paths;		# imports site-wide paths
require AdminWEB::Status;	# standard format status Class
require DB::Properties;		# Properties database Class
require AdminWEB::CGI;			# CGI interface Class

### the eval catches any runtime errors so we can report them.
$cgi_header_generated = 0;
eval q{ Action(); };
print cgi_header('text/plain'), $@ if $@;
exit(0);

sub Action {
    my $cgi = new AdminWEB::CGI;

    ### Bookmark mode -- Redirect user to a completed "get-style" URL
    if ($cgi->param('Action') eq 'Bookmark') {
        print 'Location: ' . bookmark($cgi) . "\r\n\r\n";
        return;
    }

    my $navigator = Create DB::Properties($_PATH_NAVIGATOR_PROP);
    my $properties = Create DB::Properties($_NAME_PROPERTIES);
    $properties->writable or die "$prop_file: Permission denied\n";

    my $DEBUG = $cgi->param('Debug') || $properties->value('Debug');

    my $stat = Create AdminWEB::Status("Status: System Shutdown");

    ### PROCESS CGI DATA

    require './initialize.pl';
    Initialize();

    ### Build the shutdown command line

    my @cmd;
    push(@cmd, $_PATH_SHUTDOWN);

    push(@errors, 'Invalid Mode: ' . $cgi->param('mode'))
	unless exists $modes{$cgi->param('mode')};
    push(@cmd, $modes{$cgi->param('mode')}) if $modes{$cgi->param('mode')};

    my $when_date = $cgi->param('when_date');
    if (defined $when_date && $when_date ne '') {
	# user typed in something in the input box, try to figure it out..
	if ($when_date =~ /^\+(\d+)$/) {
	    # shutdown +minutes format is ok.
	    push(@cmd, $when_date);
	}
	else {
	    # try to use getdate to figure it out
	    use Date::GetDate;
	    my $now = time;			# mark the time
	    my $time = getdate($when_date);
	    if (! defined $time || $time < 1) {
		push(@errors, 'Bad Time Format: ' . $when_date);
	    }
	    elsif ($time < $now) {
		push(@errors, 'Cannot shutdown before now: ' . $when_date);
	    }
	    $time = int(($time-$now)/60);	# convert to minutes
	    push(@cmd, "+$time");		# convert to shutdown format
	}
    }
    else {
	# from the pop-up menu -- errors here should never happen
	# unless *.view and *.cgi are out of sync
	push(@errors, 'Invalid Time: ' . $cgi->param('when'))
	    unless exists $times{$cgi->param('when')};
	push(@cmd, $times{$cgi->param('when')});
    }

    push(@cmd, $cgi->param('message')) if $cgi->param('message');

    $stat->warning('Are You Sure?');

    ### END -- PROCESS CGI DATA

    # watch out for SIGPIPE when doing output
    $SIG{'PIPE'} = 'IGNORE';

    print cgi_header('text/html');

    if ($stat->errors) {
	$stat->ReportErrors("Error(s) in Form Data");
	print $stat->HTML;
	return;
    }

    if ($stat->warnings && $cgi->param('Action') ne 'Confirmed') {
	$stat->ReportWarnings("Warning(s): Requires Confirmation",
	    confirmation($cgi));
	print $stat->HTML;
	return;
    }

    if ($cgi->param('Verify') || $cgi->param('Action') eq 'Verify') {
	$stat->Report("Form Data Verified OK");
	print $stat->HTML;
	return;
    }

    # print any debugging information you need
    if ($DEBUG) {
	print "<P>\n<B>DEBUG:</B> @cmd\n$cgi\n";
	return;
    }

    if ($navigator->value('Demo')) {
	$stat->Report("DEMO", ["No action was taken at this time."]);
	print $stat->HTML;
	exit(0);
    }

    ### Handle Normal Case

    # flush output
    $| = 1; print ''; $| = 0;

    use IO::Pipe;
    use POSIX qw(dup2 sigaction setsid);
    use Symbol;

    my ($reader, $writer) = (gensym(), gensym());
    pipe($reader, $writer) or die "pipe: $!\n";

    ### run the command
    my $pid = fork;
    if (! defined $pid) {
	### error
	$stat->Report("Error Executing Command", ["fork: $!"]);
    }
    elsif ($pid == 0) {
	### child
	# setup to write to $writer side of pipe
	setsid();
	close($reader);
	close(STDIN);
	open(STDIN, "< /dev/null");
	dup2(fileno($writer), fileno(STDOUT)) or do {
	    print $writer "dup2 STDOUT failed: $!\n";
	    exit(1);
	};
	dup2(fileno($writer), fileno(STDERR)) or do {
	    print $writer "dup2 STDERR failed: $!\n";
	    exit(1);
	};
	exec @cmd;
	print $writer "exec(@cmd) failed: $!\n";
	exit(1);
    }
    else {
	### parent
	# setup to read $reader side of pipe
	close($writer);			# or else we'll never see the EOF

	# setup alarm handler so we don't hang forever
	sub main::alarm_handler { $main::unalarmed = 0; }
	my $sigset = new POSIX::SigSet &POSIX::SIGALRM
	    or die "sigset ALRM: $!\n";
	my $action = new POSIX::SigAction('main::alarm_handler', $sigset, 0);
	my $oaction = new POSIX::SigAction;
	sigaction(&POSIX::SIGALRM, $action, $oaction)
	    or die "sigaction ALRM: $!\n";

	# we're going to read into @output
	my @output;
	$main::unalarmed = 1;		# flag cleared by alarm_handler
	alarm(2);			# give it 2 seconds
	while ($main::unalarmed && ($_ = <$reader>)) {
	    push (@output, $_);		# gather the output from @cmd
	}
	close($reader);			# done with $reader now
	waitpid($pid,0)			# we want the childs status
	    or die "waitpid: $!\n";
	alarm(0);			# clear the alarm
	if (($? >> 8) != 0) {
	    $stat->error(@output);
	    $stat->ReportErrors("Shutdown Failed");
	    print $stat->HTML;
	    return;
	}
	else {
	    $stat->Report("Command Successful",
		["shutdown is running", @output]);
	}
    }
    print $stat->HTML;
    exit(0);
}
