#!/usr/bin/perl5
#
# Navigator function for BSDI AdminWEB
#
# Copyright (c) 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI Navigator.cgi,v 1.27 1997/04/17 21:15:45 sanders Exp
#

use lib $ENV{'DOCUMENT_ROOT'};

package Navigator;

use AdminWEB::Paths;		# site-wide paths
require DB::Properties;		# properties database
require HTML::Markup::HTML2;	# HTML Object Builder
require Navigator::NamedTreeHTMLView;	# A DataType::NamedTree that
				# renders as a nicely formatted
				# HTML::Markup::HTML2('Table')

### global menu structure (it's basically a tree)
$menu = Create Navigator::NamedTreeHTMLView("MaxIM");
$menu->{'description'} = "MaxIM";

print "Content-Type: text/html\r\n\r\n";

### Traverse the filesystem building up data in $menu
require "find.pl";
local $properties;		# holds the file names found by find()
find('.');			# NOTE: find() changes directories
map { add_interface($_) } @$properties;
@$properties = ();

my $navigator = eval { Create DB::Properties("./Properties") };
if ($@) {
    # print it out so it logs in the error log
    print STDERR "Navigator Failure: $@\n";

    $@ =~ s/ at .*//;
    $@ = "Unable to obtain lock after 15 seconds"
	if $@ =~ m/Operation timed out/;
    print "<HTML><HEAD><TITLE>MaxIM Navigator Error</TITLE></HEAD>\n";
    print "<BODY><H1>Error</H1>\n";
    print "<P>Navigator failed to open the global properties file: $@\n";
    print "</BODY>\n";
    exit(0);
}
$navigator->noautosave;

### Generate the HTML from $menu -- first a nice little header
my $html = $self->{'HTMLObject'} = Create HTML::Markup::HTML2;
$html->HEAD->TITLE->Text($navigator->value('Navigator_Description'));
my $body = $html->BODY;
$body->attribute('bgcolor', "a5dbc6");
$body->attribute('text', "000000");
$body->attribute('link', "006600");
$body->attribute('vlink', "996633");
my $p;

### Icon from our Properties file
$body->A->href($navigator->value('Navigator_JapaneseURL'))->Text($navigator->value('Navigator_JapaneseChar'));
$body->P;

my $a = $body;
$a = $body->A->href($navigator->value('Navigator_ViewIconURL'))
    if $navigator->value('Navigator_LIconURL');
$a->IMG->alt($navigator->value('Navigator_LIconAlt'))
	->src($navigator->value('Navigator_LIcon'))->align('left')->border(0)
    if $navigator->value('Navigator_LIcon');

$a = $body;
$a = $body->A->href($navigator->value('Navigator_RIconURL'))
    if $navigator->value('Navigator_RIconURL');
$a->IMG->alt($navigator->value('Navigator_RIconAlt'))
	->src($navigator->value('Navigator_RIcon'))->align('right')->border(0)
    if $navigator->value('Navigator_RIcon');

### Description from our Properties file
$body->H1->CENTER->Text($navigator->value('Navigator_Description'));

$body->BR->clear('all');

### Process $menu (built above by add_interface()) into a nice table
$body->P->link( $menu->MakeTable );

### footer icon
$a = $body;
$a = $body->A->href($navigator->value('Navigator_Icon2URL'))
    if $navigator->value('Navigator_Icon2URL');
$a->CENTER->IMG->alt($navigator->value('Navigator_Icon2Alt'))
	->src($navigator->value('Navigator_Icon2'))->border(0)
    if $navigator->value('Navigator_Icon2');

### footer text
$body->P->Literal($navigator->value('Navigator_Copyright'));
print $html->realize;

exit;

### wanted() is called by find(), we just push Properties file unto an array
# beware that find() does chdir()'s
sub wanted {
    my ($dev,$ino,$mode,$nlink,$uid,$gid);
    /^$_NAME_PROPERTIES$/o &&
    (($dev,$ino,$mode,$nlink,$uid,$gid) = lstat($_)) &&
    -f _ &&
    push(@$properties, $dir);
}

sub add_interface {
    my ($dir) = @_;		              	# called from wanted()

    ### Add entry to $menu
    my $entry = $menu;				# index $menu
    my ($child, $child_path);

    # The root ./Properties file gets ignored here because there is nothing
    # left after the split & shift so there is no need to special case it.
    my @paths = split('/', $dir);
    shift @paths;				# drop the leading ./

PATH:
    foreach $child (@paths) {
	$child_path .= $child . '/';		# current partial path

	### do we already have an entry for $child in the current object?
	if (! $entry->exists($child)) {
	    my $desc = $child;			# default DESC to path element

	    my $propfile = $child_path . $_NAME_PROPERTIES;

	    ### Look for icons and directory descriptions
	    if (-r $propfile) {
		my $prop = eval { Create DB::Properties($propfile) };
		if ($@) {
		    # probably a lock timeout
		    $@ =~ s/ at .*//;
		    $desc = $child . " [$@]";
		}
		else {
		    $prop->noautosave;

		    if ($prop->value('Navigator_Hidden') eq 'true') {
			# make sure properties file is closed
			undef $prop;
			last PATH;
		    }

		    $desc = ($prop->value('Navigator_Description') || $child);

		    # add icon, if any
		    $desc .= join('',
			q{<BR><IMG ALT="" BORDER="0" SRC="},
			$prop->value('Navigator_Icon'),
			q{">},
		    ) if $prop->value('Navigator_Icon');

		    # wrap an anchor around $desc if Navigator_URL or...
		    if ($prop->defined('Navigator_URL')) {
			$desc = join('',
			    q{<A HREF="}, $prop->value('Navigator_URL'), q{">},
			    $desc,
			    q{</A>},
			);
		    }
		    # View for this directory
		    elsif (-f $child_path . $prop->value('Navigator_View')) {
			$desc = join('',
			    q{<A HREF="}, $_NAME_VIEW, '/',
			    $child_path, $prop->value('Navigator_View'),
			    q{">}, $desc, q{</A>},
			);
		    }
		}
		# make sure properties file is closed
		undef $prop;
	    }

	    ### create a new entry for $child and add it to $entry
	    my $new = Create Navigator::NamedTreeHTMLView($child);
	    $new->{'description'} = $desc;
	    $entry->set($new);
	}

	# advance $entry to $child's object
	$entry = $entry->namedchild($child);
    }
}
