/*
 * Copyright (c) 1994 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI acpi.h,v 1.1 2001/02/21 20:28:02 jch Exp
 */


/*
 *	ACPI SMAP definitions
 */

#define	ACPI_BIOS_SMAP		0xe820

#define ACPI_SMAP_SIG		0x534D4150	/* 'SMAP' */

/* Structure used for SMAP calls */
struct acpi_smap {
	u_int64_t	sm_base;
	u_int64_t	sm_length;
	u_int32_t	sm_type;
} __attribute__ ((packed));

#define	ACPI_SMAP_MINLEN	20

/* Memory types returned */
#define	ACPI_SMAP_MEMORY	1	/* AddressRangeMemory */
#define	ACPI_SMAP_RESV		2	/* AddressRangeReserved */
#define	ACPI_SMAP_ACPI		3	/* AddressRangeACPI */
#define	ACPI_SMAP_NVS		4	/* AddressRangeNVS */

