/*
 * Copyright (c) 1995, 1996 Berkeley Software Design, Inc.  All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI compat.h,v 2.3 1997/09/12 18:02:44 jch Exp
 */

/*
 * Compatibility options.  The high kernel uses a series of (largely)
 * independent COMPAT_* names for each backward-compatibility system call
 * or group of syscalls.  Here we translate `target' compatibility names
 * (such as COMPAT_BSDI11 for BSD/OS 1.1) into these `internal' names.
 * Some names (e.g. COMPAT_DEV and COMPAT_TTYIOCTL) must be configured
 * individually.
 */

#ifndef _MACHINE_COMPAT_H_
#define _MACHINE_COMPAT_H_

/* The list: */
/* COMPAT_CREAT		creat() syscall (now libc+open) */
/* COMPAT_DEV		16-bit dev_t (now 32-bit) */
/* COMPAT_GETDIRENTRIES	getdirentries w/o file type field */
/* COMPAT_GETEGID	getegid side effect in getgid (now separate syscall) */
/* COMPAT_GETEUID	geteuid side effect in getuid (now separate syscall) */
/* COMPAT_GETHOSTID	gethostid syscall (now via sysctl) */
/* COMPAT_GETKERNINFO	getkerninfo syscall (now sysctl) */
/* COMPAT_GETPAGESIZE	getpagesize syscall (now via sysctl) */
/* COMPAT_GETPPID	getppid side effect in getpid (now separate syscall) */
/* COMPAT_HOSTNAME	get/set hostname (now via sysctl) */
/* COMPAT_IFIOCTL	use of SIOCSIF* except for AF_LINK sockets */
/* COMPAT_KILLPG	killpg syscall (now via kill) */
/* COMPAT_LSEEK		32-bit lseek */
/* COMPAT_MMAP		32-bit mmap w/ old permission fields */
/* COMPAT_OLDSOCK	old-style sockaddr w/o sa_len field */
/* COMPAT_QUOTA		oquota = ENOSYS: useless; why? */
/* COMPAT_RLIMIT	32-bit get/set rlimits */
/* COMPAT_SETHOSTID	sethostid syscall (now via sysctl) */
/* COMPAT_SETREID	setreuid, setregid (now via set{,r,e}{u,g}id) */
/* COMPAT_SIGNAL	sigblock,sigvec,etc (now sigprocmask,sigaction) */
/* COMPAT_STAT		32-bit {,f}stat */
/* COMPAT_SUNOS		SunOS compat; not on i386 */
/* COMPAT_TRUNCATE	32-bit {,f}truncate */
/* COMPAT_TTYIOCTL	V7/4.1-compatible sgtty/"new" tty interface */
/* COMPAT_WAIT3		vax/HP wait3 (need on hp for hpux too) */

/*
 * "4.3" compatibility: should never be needed;
 * this stuff predates the i386 port.
 */
#ifdef COMPAT_43
#define	COMPAT_CREAT
#define	COMPAT_GETEGID
#define	COMPAT_GETEUID
#define	COMPAT_GETPPID
#define	COMPAT_KILLPG
#define	COMPAT_OLDSOCK
#define	COMPAT_QUOTA
#define	COMPAT_SIGNAL
#define	COMPAT_WAIT3
#endif /* COMPAT_43 */

/*
 * Compatibility with binaries built for BSD/OS (aka BSD/386) version 1.1
 * and previous releases
 */
#if defined(COMPAT_43) || defined(COMPAT_BSDI11)
/* #define COMPAT_DEV 		should not be needed */
#define COMPAT_GETDIRENTRIES
#define	COMPAT_GETHOSTID
#define COMPAT_GETKERNINFO
#define COMPAT_GETPAGESIZE
#define COMPAT_GETHOSTNAME
#define COMPAT_LSEEK
#define COMPAT_MMAP
#define COMPAT_RLIMIT
#define	COMPAT_SETHOSTID	/* should not be needed ??? */
#define COMPAT_SETHOSTNAME	/* should not be needed ??? */
#define	COMPAT_SETREID
#define COMPAT_STAT
#define COMPAT_TRUNCATE
#ifndef COMPAT_TTYIOCTL
#define	COMPAT_TTYIOCTL
#endif
#endif /* COMPAT_43 || COMPAT_BSDI11 */

#endif /* !_MACHINE_COMPAT_H_ */
