/*
 * Copyright (c) 1998 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI compiler.gcc.h,v 2.1 1998/09/09 03:34:25 torek Exp
 */

/*
 * Compiler-specific tricks for gcc.
 *
 * The ARGUSED macro tells the compiler not to complain about a
 * formal parameter that is not used within a function body.  (In
 * C++ one would just leave out the parameter name to mean this.)
 * Its argument must be a variable name and cannot be labelled
 * "register" (why would you make an unused variable "register"?).
 *
 * The INITVAL macro tells the compiler not to complain that a
 * variable is uninitialized.  Its argument must be a variable name.
 * (For instance, when the program has code of the form:
 *	if (test) x = something();
 *	...
 *	if (test) use(x);
 * the compiler may think that "x may be used uninitialized".  Use
 * INITVAL -- very carefully! -- to shut it up; or just initialize
 * it, which will always work too.)
 *
 * These need not expand to anything, and/or INITVAL may always assign
 * the constant 0 to its argument (0 is a valid integer, fp number, and
 * pointer).
 */

/*
 * In GCC2, cast to void suffices for ARGUSED.
 */
#define	ARGUSED(x)	(void)(x)

/*
 * GCC2 makes it hard to lie about initialization.  The tricky asm
 * here says "put X in any general register or anything and we will
 * write on it", and then we emit no instructions.
 */
#if 1 /* not entirely confident about this one */
#define	INITVAL(x)	__asm__("" : "=rX"(x))
#else
#define	INITVAL(x)	(x = 0)
#endif
