/*-
 * Copyright (c) 1997 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI dr.h,v 2.2 1997/10/28 22:43:27 ewv Exp
 */

#ifndef _MACHINE_DR_H_
#define _MACHINE_DR_H_

/*
 * x86 Debug Register definitions
 */
#define mkstr(a) # a
#define getdr(n) ({                                                     \
        int _x;                                                         \
        asm volatile ("movl " mkstr(%%db ## n) ",%0" : "=r" (_x));     \
        _x;                                                             \
})
#define setdr(n, v) asm volatile ("movl %0, " mkstr(%%db ## n) :: "r" (v))

/* DR6 - debug status */
#define	DR6_B0 0x00000001	/* breakpoint 0 */
#define	DR6_B1 0x00000002	/* breakpoint 1 */
#define	DR6_B2 0x00000004	/* breakpoint 2 */
#define	DR6_B3 0x00000008	/* breakpoint 3 */
#define	DR6_BD 0x00002000	/* debug register access */
#define	DR6_BS 0x00004000	/* single step exception */
#define	DR6_BT 0x00008000	/* switch to debugged task */

/* DR7 - debug control */
#define	DR7_L0		0x00000001	/* Enable B0 - local */
#define	DR7_G0		0x00000002	/* Enable B0 - global */
#define	DR7_L1		0x00000004	/* Enable B1 - local */
#define	DR7_G1		0x00000008	/* Enable B1 - global */
#define	DR7_L2		0x00000010	/* Enable B2 - local */
#define	DR7_G2		0x00000020	/* Enable B2 - global */
#define	DR7_L3		0x00000040	/* Enable B3 - local */
#define	DR7_G3		0x00000080	/* Enable B3 - global */
#define	DR7_LE		0x00000100	/* exact local breakpoints (386) */
#define	DR7_GE		0x00000200	/* exact global breakpoints (386) */

#define	DR7_RW0_SHFT	16
#define	DR7_RW0_MASK	0x00030000
#define	DR7_LEN0_SHFT	18
#define	DR7_LEN0_MASK	0x000c0000
#define	DR7_RW1_SHFT	20
#define	DR7_RW1_MASK	0x00300000
#define	DR7_LEN1_SHFT	22
#define	DR7_LEN1_MASK	0x00c00000
#define	DR7_RW2_SHFT	24
#define	DR7_RW2_MASK	0x03000000
#define	DR7_LEN2_SHFT	26
#define	DR7_LEN2_MASK	0x0c000000
#define	DR7_RW3_SHFT	28
#define	DR7_RW3_MASK	0x30000000
#define	DR7_LEN3_SHFT	30
#define	DR7_LEN3_MASK	0xc0000000

#define	DR7_RW_INSTR	0x0		/* Break on instruction fetch */
#define DR7_RW_DWRITE	0x1		/* Break on data write */
#define	DR7_RW_IO	0x2		/* Break on I/O read/write */
#define	DR7_RW_DRW	0x3		/* Break on data read/write */

#define	DR7_LEN1	0x0		/* One byte */
#define	DR7_LEN2	0x1		/* Two byte */
#define	DR7_LEN4	0x3		/* Four byte */

#endif /* !_MACHINE_DR_H_ */
