/*-
 * Copyright (c) 1996 Berkeley Software Design, Inc.  All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI setjmp.h,v 2.2 1996/10/11 16:00:53 pjd Exp
 */

#ifndef _MACHINE_SETJMP_H_
#define _MACHINE_SETJMP_H_

/*
 * Machine-dependent setjmp(3) declarations for the i386.
 * Only the size of this structure is actually used;
 * otherwise it is provided merely as documentation.
 */

struct __jmp_buf {
	int	jb_eip;
	int	jb_ebx;
	int	jb_esp;
	int	jb_ebp;
	int	jb_esi;
	int	jb_edi;
	int	jb_mask;
	int	jb_pad[3];	/* preserve historical mistake */
};

typedef struct __jmp_buf jmp_buf[1];

#if !defined(_ANSI_SOURCE) || defined(_POSIX_SOURCE)
typedef struct {
	struct	__jmp_buf sjb_buf;
	int	sjb_restore_mask;
} sigjmp_buf[1];
#endif

#endif /* !_MACHINE_SETJMP_H_ */
