/*-
 * Copyright (c) 1995, 1998 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI shlib.h,v 2.11 2001/02/05 17:11:07 donn Exp
 */

#ifndef _MACHINE_SHLIB_H_
#define _MACHINE_SHLIB_H_

/*
 * Machine-dependent definitions for BSD/OS static shared libraries.
 */

#ifdef LOCORE

/*
 * Assembly defines, used in creating jump tables and stub objects.
 */


#define	JUMPTO(addr)	.align 8; jmp addr

#define	PAGE_ALIGN	.align 4096

#define	JUMPENTRY(j,addr) \
	.global j; \
	.align 8; \
	j: \
		jmp addr

#define	DEFDATA(n,sz)	.section ".data"; .global n; n: .space sz


/*
 * On some machines, STUB_TEXT() performs a long branch to a jump table slot.
 * On this machine, we can branch directly to the jump table slot.
 * I'm not really sure what the point of STUB_DATA() is...
 */
#define	STUB_TEXT(n,v) \
	.globl n; \
	.set n,v
#define	STUB_DATA(n,v) \
	.globl n; \
	.set n,v

#else

/*
 * C defines, used in bootstrapping.
 */

/*
 * Optional assembly glue at the start of the text segment.
 * On the i386, we jump directly to the entry point of the library,
 * so this frob is unneeded.  (XXX Is it needed elsewhere?)
 */
#define	ENTRY

/*
 * Structure of the library table __LIBRARY_TABLE[].
 *
 * The name field lists the pathname of the library.
 * The address field gives the base address of the library's text segment;
 * the loader maps the first page at the given address and
 * calls the entry point to complete the segment loading.
 * Initialization functions are called after all libraries
 * have been loaded, in order from right to left.
 * At the same time, the finalization routines are scheduled with atexit()
 * to be run in order from left to right.
 *
 * The table resides in the application, and it is constructed by shlicc(1).
 * The name and address fields are initialized statically;
 * the function pointers are set by the loader functions,
 * to pass values back to the start-up code (in the C library).
 */
struct ldtab {
	char *name;
	caddr_t address;
};

struct initfini {
	void (*init)(void);
	void (*fini)(void);
};

/*
 * Prototype declarations.
 */

void loader __P((struct ldtab *, int, int, struct initfini *));

/* don't forget the obnoxious pad word */
caddr_t __mmap __P((caddr_t, size_t, int, int, int, int, off_t));
void __abort __P((void));

void _init(void);
void _fini(void);

/* We process the ps_strings pointer in LIBC_ENTRY, not as a parameter.  */
#define	NO_PARAMETERS		1

/* These hooks are available to do machine-specific work at start-up.  */
#define	DO_LIBC_INIT()
#define	DO_INIT(ip) \
do { \
	ip->init = _init; \
	ip->fini = _fini; \
} while (0)

#include <sys/elf.h>

#define	LIBRARY \
	asm ("\n" \
	"	.section \".text\"\n" \
	"	.type __mmap,@function\n" \
	"	.align 4\n" \
	"__mmap:\n" \
	"	leal 197,%eax\n" \
	"	lcall $7,$0\n" \
	"	jb 0f\n" \
	"	ret\n" \
	"0:\n" \
	"	movl $-1,%eax\n" \
	"	ret\n" \
	"	.type __abort,@function\n" \
	"	.align 4\n" \
	"__abort:\n" \
	"	hlt");

#define	LOAD_SEGMENTS(lp, f, pagesz) \
{ \
	Elf32_Ehdr *e = (Elf32_Ehdr *)lp->address; \
	Elf32_Phdr *p; \
	unsigned int i; \
	caddr_t v, end; \
	off_t o; \
	size_t len, mem; \
	int prot; \
\
	for (i = 0; i < e->e_phnum; ++i) { \
		p = (Elf32_Phdr *) \
		    ((caddr_t)e + e->e_phoff + i * e->e_phentsize); \
		if (p->p_type != PT_LOAD) \
			continue; \
		prot = 0; \
		if (p->p_flags & PF_R) \
			prot |= PROT_READ; \
		if (p->p_flags & PF_W) \
			prot |= PROT_WRITE; \
		if (p->p_flags & PF_X) \
			prot |= PROT_EXEC; \
		v = (caddr_t)i386_trunc_page(p->p_vaddr); \
		len = i386_round_page(p->p_filesz); \
		mem = i386_round_page(p->p_memsz); \
		o = i386_trunc_page(p->p_offset); \
		if (v == lp->address) { \
			/* skip the loader page */ \
			v += CLBYTES; \
			len -= CLBYTES; \
			mem -= CLBYTES; \
			o += CLBYTES; \
		} \
		if (__mmap(v, len, prot, MAP_PRIVATE|MAP_FIXED, f, 0, o) == \
		    (caddr_t)-1) \
			__abort(); \
		if (mem > len && __mmap(v + len, mem - len, prot, \
		    MAP_ANON|MAP_FIXED, -1, 0, 0) == (caddr_t)-1) \
			__abort(); \
		if (prot & PROT_WRITE && p->p_filesz & CLOFSET) { \
			/* Zero out BSS fragment in last page of data.  */ \
			mem = CLBYTES - (p->p_filesz & CLOFSET); \
			end = v + len - mem; \
			if (mem > p->p_memsz - p->p_filesz) \
				mem = p->p_memsz - p->p_filesz; \
			bzero(end, mem); \
		} \
	} \
}

#define	LIB_START(v) \
	((void (*)(struct ldtab *, int, int, struct initfini *)) \
	    (((Elf32_Ehdr *)(v))->e_entry))

/* Used instead of ENTRY in the C library loader.  */
#define	LIBC_ENTRY(f) \
	asm ("\n" \
	"	.global loader\n" \
	"	.type loader,@function\n" \
	"	.section \".init\"\n" \
	"loader:\n" \
	"	movl %ebx,__ps_strings\n" \
	"	xorl %ebp,%ebp\n" \
	"	jmp " f "\n");

#endif /* C */

#endif /* !_MACHINE_SHLIB_H_ */
