/*-
 * Copyright (c) 1999 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI romfs.h,v 1.3 2001/03/06 16:22:30 giff Exp
 */

/*-
 * Copyright (c) 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley
 * by Pace Willisson (pace@blitz.com).
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _KROMFS_H_
#define _KROMFS_H_

#ifdef	KERNEL
struct romfs_mnt {
	int im_flags;

	struct mount *rm_mountp;
	dev_t rm_dev;
	struct vnode *rm_devvp;
	struct vnode *rm_rootvp;
	u_long	rm_size;
	u_long	rm_files;

	struct netexport rm_export;
};
#endif

struct romfs_args {
	char	*fspec;                 /* block special device to mount */
        struct	export_args export;     /* network export info */
        int	flags;                  /* mounting flags, see below */
};

#ifdef	KERNEL

#define VFSTOROMFS(mp)	((struct romfs_mnt *)((mp)->mnt_data))

#define	RFS_BSIZE	512
#define	RFS_BMASK	(RFS_BSIZE-1)
#define	RFS_BSHIFT	9

int romfs_mount __P((struct mount *,
	    char *, caddr_t, struct nameidata *, struct proc *));
int romfs_start __P((struct mount *, int, struct proc *));
int romfs_unmount __P((struct mount *, int, struct proc *));
int romfs_root __P((struct mount *, struct vnode **));
int romfs_quotactl __P((struct mount *, int, u_int, void *, struct proc *));
int romfs_statfs __P((struct mount *, struct statfs *, struct proc *));
int romfs_sync __P((struct mount *, int, struct ucred *, struct proc *));
int romfs_vget __P((struct mount *, ino_t, struct vnode **));
int romfs_fhtovp __P((struct mount *, struct fid *, struct sockaddr *,
	    struct vnode **, int *, struct ucred **));
int romfs_vptofh __P((struct vnode *, struct fid *));
int romfs_init __P((struct vfsconf *));
#define romfs_sysctl ((int (*) __P((int *, u_int, void *, size_t *, void *, \
                                    size_t, struct proc *)))eopnotsupp)

int romfs_mountroot __P((void)); 

extern int (**romfs_vnodeop_p)();
extern int (**romfs_specop_p)();
#ifdef FIFO
extern int (**romfs_fifoop_p)();
#endif

int romfs_abortop __P((struct vop_abortop_args *));
int romfs_access __P((struct vop_access_args *));
int romfs_blkatoff __P((struct vop_blkatoff_args *));
int romfs_bmap __P((struct vop_bmap_args *));
int romfs_close __P((struct vop_close_args *));
int romfs_getattr __P((struct vop_getattr_args *));
int romfs_inactive __P((struct vop_inactive_args *));
int romfs_ioctl __P((struct vop_ioctl_args *));
int romfs_islocked __P((struct vop_islocked_args *));
int romfs_lock __P((struct vop_lock_args *));
int romfs_lookup __P((struct vop_lookup_args *));
int romfs_mmap __P((struct vop_mmap_args *));
int romfs_open __P((struct vop_open_args *));
int romfs_pathconf __P((struct vop_pathconf_args *));
int romfs_print __P((struct vop_print_args *));
int romfs_read __P((struct vop_read_args *));
int romfs_readdir __P((struct vop_readdir_args *));
int romfs_reclaim __P((struct vop_reclaim_args *));
int romfs_seek __P((struct vop_seek_args *));
int romfs_strategy __P((struct vop_strategy_args *));
int romfs_unlock __P((struct vop_unlock_args *));

#define romfs_revoke vop_revoke
#define romfs_select vop_regselect
#define	romfs_pager vop_regpager

struct vnode *romfs_ihashget __P((dev_t, ino_t));
void romfs_ihashins __P((rfnode_t *));
void romfs_ihashrem __P((rfnode_t *));
int romfs_readdata __P((struct vnode *, void *, off_t, int, struct buf **));
int romfs_readdirentry __P((struct vnode *, off_t *, struct buf **, 
	    struct dirent *));

#endif

#endif /* !_KROMFS_H_ */
