/*-
 * Copyright (c) 2000 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *      BSDI if_802_11.h,v 1.6 2000/10/13 20:02:22 prb Exp
 */

/*
 * Snap Header information
 */
#define IEEE_802_11_SNAP_K1		0xaa 	/* assigned SAP for SNAP */
#define IEEE_802_11_SNAP_K2		0x00
#define IEEE_802_11_SNAP_CONTROL	0x03	/* unnumbered info format */
#define IEEE_802_11_SNAPHDR_LEN		8	/* 6 byte hdr + 2 byte type */

/*
 * 802.11 Frame Control bits
 */
/* Byte 0 Protocol Version Bits 0-1*/
#define IEEE_802_11_PROTOCOL_VERSION	0x00

/* Byte 0 Type Bits 2-3*/
#define IEEE_802_11_TYPE_MGMT		0x00
#define IEEE_802_11_TYPE_CTL		0x04
#define IEEE_802_11_TYPE_DATA		0x08
#define IEEE_802_11_TYPE_RESERVED	0x0c

#define IEEE_802_11_TYPE_MASK		0x0c

/* Byte 0 Subtype Bits 4-7 */
#define	IEEE_802_11_SUBTYPE_MASK	0xF0

/* Byte 0 Subtype Bits 4-7 Management */
#define	IEEE_802_11_MGMT_ASREQ		0x00
#define	IEEE_802_11_MGMT_ASRESP		0x10
#define	IEEE_802_11_MGMT_REASREQ	0x20
#define	IEEE_802_11_MGMT_REASRESP	0x30
#define	IEEE_802_11_MGMT_PROBEREQ	0x40
#define	IEEE_802_11_MGMT_PROBERESP	0x50
#define	IEEE_802_11_MGMT_RESERVED6	0x60
#define	IEEE_802_11_MGMT_RESERVED7	0x70
#define	IEEE_802_11_MGMT_BEACON		0x80
#define	IEEE_802_11_MGMT_ATIM		0x90
#define	IEEE_802_11_MGMT_DISAS		0xA0
#define	IEEE_802_11_MGMT_AUTH		0xB0
#define	IEEE_802_11_MGMT_DEAUTH		0xC0
#define	IEEE_802_11_MGMT_RESERVEDd	0xD0
#define	IEEE_802_11_MGMT_RESERVEDe	0xE0
#define	IEEE_802_11_MGMT_RESERVEDf	0xF0

/* Byte 0 Subtype Bits 4-7 Control */
#define	IEEE_802_11_CTL_RESERVED0	0x00
#define	IEEE_802_11_CTL_RESERVED1	0x10
#define	IEEE_802_11_CTL_RESERVED2	0x20
#define	IEEE_802_11_CTL_RESERVED3	0x30
#define	IEEE_802_11_CTL_RESERVED4	0x40
#define	IEEE_802_11_CTL_RESERVED5	0x50
#define	IEEE_802_11_CTL_RESERVED6	0x60
#define	IEEE_802_11_CTL_RESERVED7	0x70
#define	IEEE_802_11_CTL_RESERVED8	0x80
#define	IEEE_802_11_CTL_RESERVED9	0x90
#define	IEEE_802_11_CTL_PS		0xA0
#define	IEEE_802_11_CTL_RTS		0xB0
#define	IEEE_802_11_CTL_CTS		0xC0
#define	IEEE_802_11_CTL_ACK		0xD0
#define	IEEE_802_11_CTL_CF_END		0xE0
#define	IEEE_802_11_CTL_CF_END_ACK	0xF0

/* Byte 0 Subtype Bits 4-7 Data */
#define	IEEE_802_11_DATA_DATA		0x00
#define	IEEE_802_11_DATA_DATA_ACK	0x10
#define	IEEE_802_11_DATA_DATA_POLL	0x20
#define	IEEE_802_11_DATA_DATA_ACK_POLL	0x30
#define	IEEE_802_11_DATA_NULL		0x40
#define	IEEE_802_11_DATA_ACK		0x50
#define	IEEE_802_11_DATA_POLL		0x60
#define	IEEE_802_11_DATA_ACK_POLL	0x70
#define	IEEE_802_11_DATA_RESERVED8	0x80
#define	IEEE_802_11_DATA_RESERVED9	0x90
#define	IEEE_802_11_DATA_RESERVEDa	0xA0
#define	IEEE_802_11_DATA_RESERVEDb	0xB0
#define	IEEE_802_11_DATA_RESERVEDc	0xC0
#define	IEEE_802_11_DATA_RESERVEDd	0xD0
#define	IEEE_802_11_DATA_RESERVEDe	0xE0
#define	IEEE_802_11_DATA_RESERVEDf	0xF0

/* Byte 1 */
#define IEEE_802_11_FCTL_TODS		0x01
#define IEEE_802_11_FCTL_FROMDS		0x02
#define IEEE_802_11_FCTL_MOREFRAGS	0x04
#define IEEE_802_11_FCTL_RETRY		0x08
#define IEEE_802_11_FCTL_PM		0x10
#define IEEE_802_11_FCTL_MOREDATA	0x20
#define IEEE_802_11_FCTL_WEP		0x40
#define IEEE_802_11_FCTL_ORDER		0x80

/*
 * 802.11 Data Frame
 */
struct	ieee_802_11_header {
	u_int8_t	e11_frame_ctl0;
	u_int8_t	e11_frame_ctl1;
	u_int16_t	e11_duration;
	u_int8_t	e11_addr1[ETHER_ADDR_LEN];
	u_int8_t	e11_addr2[ETHER_ADDR_LEN];
	u_int8_t	e11_addr3[ETHER_ADDR_LEN];
	u_int16_t	e11_seq_ctl;
	u_int8_t	e11_addr4[ETHER_ADDR_LEN];
};

#define	IEEE_802_11_HDR_LEN	30

/*
 * 802.11 Control RTS Frame
 */
struct	ieee_802_11_rts {
	u_int8_t	e11_frame_ctl0;
	u_int8_t	e11_frame_ctl1;
	u_int16_t	e11_duration;
	u_int8_t	e11_ra[ETHER_ADDR_LEN];
	u_int8_t	e11_ta[ETHER_ADDR_LEN];
};

/*
 * 802.11 Control RTS Frame (Ack is the same)
 */
struct	ieee_802_11_cts {
	u_int8_t	e11_frame_ctl0;
	u_int8_t	e11_frame_ctl1;
	u_int16_t	e11_duration;
	u_int8_t	e11_ra[ETHER_ADDR_LEN];
};

#define	ieee_802_11_ack	ieee_802_11_cts

/*
 * 802.11 Control PS-Poll Frame
 */
struct	ieee_802_11_ps {
	u_int8_t	e11_frame_ctl0;
	u_int8_t	e11_frame_ctl1;
	u_int16_t	e11_aid;
	u_int8_t	e11_bssid[ETHER_ADDR_LEN];
	u_int8_t	e11_ta[ETHER_ADDR_LEN];
};

/*
 * 802.11 Control CF-End Frame (CF-End + CF-Ack is the same)
 */
struct	ieee_802_11_cf_end {
	u_int8_t	e11_frame_ctl0;
	u_int8_t	e11_frame_ctl1;
	u_int16_t	e11_duration;
	u_int8_t	e11_ra[ETHER_ADDR_LEN];
	u_int8_t	e11_bssid[ETHER_ADDR_LEN];
};
#define	ieee_802_11_cf_end_ack	ieee_802_11_cf_end


/*
 * 802.11 Management Frame
 */
struct	ieee_802_11_mgmt {
	u_int8_t	e11_frame_ctl0;
	u_int8_t	e11_frame_ctl1;
	u_int16_t	e11_duration;
	u_int8_t	e11_da[ETHER_ADDR_LEN];
	u_int8_t	e11_sa[ETHER_ADDR_LEN];
	u_int8_t	e11_bssid[ETHER_ADDR_LEN];
	u_int16_t	e11_seqctl;
};

/*
 * 802.11 sysctl values
 */
#define	IEEE_802_11_SCTL_MULTIADDRS	1
#define	IEEE_802_11_SCTL_SSID		2
#define	IEEE_802_11_SCTL_AP		3
#define	IEEE_802_11_SCTL_CHANNEL	4
#define	IEEE_802_11_SCTL_WEPKEY		5
#define	IEEE_802_11_SCTL_WEPENABLE	6
#define	IEEE_802_11_SCTL_WEPTXKEY	7
#define	IEEE_802_11_SCTL_STATION	8
#define	IEEE_802_11_SCTL_AUTHMODE	9
#define	IEEE_802_11_SCTL_MAXID		10


#define	IEEE_802_11_NAMES {		\
	{ 0, 0 },			\
	{ "multiaddrs", CTLTYPE_STRUCT }, \
	{ "ssid",	CTLTYPE_STRUCT }, \
	{ "ap", 	CTLTYPE_STRUCT }, \
	{ "channel",	CTLTYPE_STRUCT }, \
	{ "wepkey",	CTLTYPE_STRUCT }, \
	{ "wepenable",	CTLTYPE_STRUCT }, \
	{ "weptxkey",	CTLTYPE_STRUCT }, \
	{ "station",	CTLTYPE_STRUCT }, \
	{ "authmode", 	CTLTYPE_STRUCT }, \
}

#define	IEEE_802_11_AUTH_NONE		0x00
#define	IEEE_802_11_AUTH_OPEN		0x01
#define	IEEE_802_11_AUTH_SHARED		0x02
#define	IEEE_802_11_AUTH_ENCRYPTED	0x04

/*
 * Wired Equivalent Privacy (WEP)
 */
#define	IEEE_802_11_NWEPKEYS		4	/* 4 possible keys */
#define	IEEE_802_11_MAXWEPKEYLEN	13	/* (128-24)/8 = 13 bytes */

