/*-
 * Copyright (c) 1993, 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI if_c_hdlc.h,v 2.6 1998/01/12 20:48:56 dab Exp
 */

#ifndef _IF_C_HDLC_H_
#define _IF_C_HDLC_H_

/*
 * Definitions for the cisco HDLC serial line encapsulation
 */

/*
 * Cisco packet header
 */
struct cisco_hdr {
	u_char  csh_addr;       /* link address */
	u_char  csh_ctl;        /* control -- always zero */
	u_int16_t csh_type;	/* packet type */
};

/*
 * Link addresses
 */
#define CISCO_ADDR_UNICAST      0x0f
#define CISCO_ADDR_BCAST        0x8f

/*
 * Packet type values
 */
#define CISCO_TYPE_INET         0x0800          /* IP */
#define CISCO_TYPE_INET6        0x86dd          /* IPv6 */
#define CISCO_TYPE_SLARP        0x8035          /* SLARP control packet */
#define	CISCO_TYPE_CDP		0x2000		/* Cisco Discovery Protocol */


/*
 * Cisco SLARP control packet structure
 */
struct cisco_slarp {
	int32_t	csl_code;		/* code */
	union {
	    struct {
	    	u_int32_t addr;		/* IP addr */
	    	u_int32_t mask;		/* IP addr mask */
	    	u_int16_t unused[3];
	    } addr;
	    struct {
		int32_t	myseq;		/* my sequence number */
		int32_t	yourseq;	/* your sequence number */
		int16_t	rel;		/* reliability */
		int16_t	t1;		/* time alive (1) */
		int16_t t0;		/* time alive (0) */
	    } keep;
	} un;
};

#define	SLARP_SIZE	18	/* sizeof rounds up */

#define	csl_addr	un.addr.addr
#define	csl_mask	un.addr.mask
#define	csl_myseq	un.keep.myseq
#define	csl_yourseq	un.keep.yourseq
#define	csl_rel		un.keep.rel
#define	csl_t1		un.keep.t1
#define	csl_t0		un.keep.t0

/*
 * SLARP control packet codes
 */
#define SLARP_REQUEST		0
#define SLARP_REPLY		1
#define SLARP_KEEPALIVE		2

#define HDLCMTU	1500		/* MTU for sync lines */
#define HDLCMAX	(HDLCMTU + 8)	/* Max packet size (with link-level overhead) */

/*
 * For BPF, packet directions are indicated by overloading the control
 * field.
 */
#define	CISCO_DIR_OUT	1
#define	CISCO_DIR_IN	0

#endif /* !_IF_C_HDLC_H_ */
