/*	BSDI if_ethernet.h,v 2.3 2001/02/26 14:26:01 geertj Exp	*/

/*
 * Copyright (c) 1982, 1986, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)if_ether.h	8.3 (Berkeley) 5/2/95
 */

#ifndef	_IF_ETHERNET_H_
#define	_IF_ETHERNET_H_

/*
 * Structure of a 10Mb/s Ethernet header.
 */
#define	ETHER_ADDR_LEN	6

struct	ether_header {
	u_char	ether_dhost[ETHER_ADDR_LEN];
	u_char	ether_shost[ETHER_ADDR_LEN];
	u_int16_t ether_type;
};

/*
 * Copy a 6-byte ethernet address.
 */
#define	ETHER_COPY(from, to) { \
	register u_int16_t *s = (u_int16_t *)(from); \
	register u_int16_t *d = (u_int16_t *)(to); \
	*d++ = *s++; *d++ = *s++; *d = *s; }

/*
 * Zero a 6-byte ethernet address
 */
#define ETHER_ZERO(to) { \
	register u_int16_t *d = (u_int16_t *)(to); \
	*d++ = 0; *d++ = 0; *d = 0; }

/*
 * Fill in an ethernet header.
 */
#define	ETHER_FILL_HDR(dst, src, type, eh) { \
	register u_int16_t *s = (u_int16_t *)(dst); \
	register u_int16_t *d = (u_int16_t *)(eh); \
	*d++ = *s++; *d++ = *s++; *d++ = *s; \
	s = (u_int16_t *)(src); \
	*d++ = *s++; *d++ = *s++; *d++ = *s; \
	*d = (u_int16_t)type; }

#define	ETHERTYPE_PUP		0x0200	/* PUP protocol */
#define ETHERTYPE_NS		0x0600	/* XNS/IPX protocol */
#define	ETHERTYPE_IP		0x0800	/* IP protocol */
#define	ETHERTYPE_ARP		0x0806	/* Addr. resolution protocol */
#define	ETHERTYPE_IPV6		0x86DD	/* IPv6 protocol */
#define	ETHERTYPE_REVARP	0x8035	/* reverse Addr. resolution protocol */
#define	ETHERTYPE_8021Q		0x8100	/* 802.1Q VLAN tagging */
#define	ETHERTYPE_8023X		0x8808	/* 802.3x flow control */

/*
 * The ETHERTYPE_NTRAILER packet types starting at ETHERTYPE_TRAIL have
 * (type-ETHERTYPE_TRAIL)*512 bytes of data followed
 * by an ETHER type (as given above) and then the (variable-length) header.
 */
#define	ETHERTYPE_TRAIL		0x1000		/* Trailer packet */
#define	ETHERTYPE_NTRAILER	16

#define	ETHER_IS_MULTICAST(addr) (*addr & 0x01)	/* is address mcast/bcast? */

#define	ETHERMTU	1500
#define	ETHERMIN	(60-14)

#ifdef  KERNEL
u_char	etherbroadcastaddr[ETHER_ADDR_LEN];
u_char	etherflowcontroladdr[ETHER_ADDR_LEN];
#endif /* KERNEL */

#endif	/* !_IF_ETHERNET_H_ */
