/*-
 * Copyright (c) 1997 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI if_fr.h,v 1.5 1999/08/26 22:54:14 prb Exp
 */
#define	FR_LMI_TYPE_ANSI	1
#define	FR_LMI_TYPE_FRIF	2	/* Not fully supported */
#define	FR_LMI_TYPE_CCITT	3
#define	FR_LMI_TYPE_CISCO	4	/* Not fully supported */
#define	FR_LMI_DEF_TYPE		FR_LMI_TYPE_ANSI

#define  FR_DTE  0    /* type DTE (normal)  */
#define  FR_DCE  1    /* type DCE (emulation for test only) */

/*
 * N391 - Polling cycles for full status of all PVC's
 * N392 - Number of errors occurring during N393 monitored events
 * N393 - Monitored events counter
 * T391 - Link integrity verification polling timer
 * T392 - Polling verification timer (not currently used)
 */
#define	FR_MIN_N391	1
#define	FR_DEF_N391	6
#define	FR_MAX_N391	255

#define	FR_MIN_N392	1
#define	FR_DEF_N392	3
#define	FR_MAX_N392	10

#define	FR_MIN_N393	1
#define	FR_DEF_N393	4
#define	FR_MAX_N393	10

#define	FR_MIN_T391	5
#define	FR_DEF_T391	10
#define	FR_MAX_T391	30

#define	FR_MIN_T392	5
#define	FR_DEF_T392	15
#define	FR_MAX_T392	30

#define	FR_DEF_BECN_USED	1
#define	FR_DEF_BECN_K	2	/* ??? */
#define	FR_DEF_BECN_N	3	/* ??? */

#define	FR_DEF_FECN_USED	1
#define	FR_DEF_FECN_K	3	/* ??? */
#define	FR_DEF_FECN_N	4	/* ??? */

#define FR_RANGE(b,v,t)   ((b) > (v) ? (b) : (v) > (t) ? (t) : (v))

#define	FR_DEF_MAX_DISPATCH	3
#define	FR_DEF_DISCARD		0
#define	FR_DEF_DN1		4000	/* maximum packet length */

/*
 * Values available for discard eligibility
 */
#define DE_OFF              0
#define DE_ROUTING          1
#define DE_ROUTING_OR_TOS   2

/*
 * Some statistics we keep track of
 */
struct fr_portstats {
	quad_t	rx_frm;		/* total frames rcvd w/o error */
	quad_t	rx_byte;	/* total byte counts */
	quad_t	rx_error;	/* software detected errors */

	quad_t	tx_frm ;	/* total frames xmitted */
	quad_t	tx_byte;	/* total byte counts */
	quad_t	tx_drop;	/* frames w/o errors dropped */
};

/*
 * Statistics that are kept per PVC                                      *
 */
struct fr_pvc_stats {
	quad_t tx_frm;
	quad_t tx_byte;
	quad_t rx_frm;
	quad_t rx_byte;
	quad_t frm_drop;
	quad_t fecn_frm;
	quad_t fecn_on;
	quad_t fecn_off;
	quad_t becn_frm;
	quad_t becn_on;
	quad_t becn_off;
};

struct fr_config {
	int	fc_type;			/* DCE vs DTE */
	int	fc_lmitype;			/* LMI type */
	int	fc_nN1;				/* N391 count */
	int	fc_nN2;				/* N392 count */
	int	fc_nN3;				/* N393 count */
	int	fc_nT1;				/* T391 count */
	int	fc_dN1;				/* Max packet size */
	int	fc_fecn_used;
	int	fc_fecn_k;
	int	fc_fecn_n;
	int	fc_becn_used;
	int	fc_becn_k;
	int	fc_becn_n;
	int	fc_max_dispatch;
	int	fc_discard_eli;
	int	fc_mode;			/* Selected if_flags */
	u_long	fc_dlci;			/* default DLCI */
};

struct fr_req {
	char	fr_name[IFNAMSIZ];	/* if name, e.g. "en0" */
	struct	fr_config fr_config;
};

struct fr_map {
        struct	in_addr ipaddr;
        struct	in_addr mask;
	u_long	raw:1;
	u_long	dlci:23;
};

struct fr_rtreq {
	char	fr_name[IFNAMSIZ];		/* if name, e.g. "en0" */
	struct	fr_map	map;
};

struct fr_mapreq {
	char	fr_name[IFNAMSIZ];		/* if name, e.g. "en0" */
	struct	fr_map *fr_map;			/* where to stuff the data */
	int	fr_size;			/* number of bytes avail/used */
};

#define FR_SCONFIG      _IOW('i', 130, struct fr_req)
#define FR_GCONFIG      _IOWR('i', 131, struct fr_req)
#define FR_SROUTE	_IOW('i', 132, struct fr_rtreq)
#define FR_CROUTE	_IOWR('i', 133, struct fr_rtreq)
#define FR_GROUTE	_IOWR('i', 134, struct fr_mapreq)
#define FR_GMAP		_IOWR('i', 135, struct fr_mapreq)
