/*-
 * Copyright (c) 1996 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI if_media.h,v 1.15.2.1 2001/03/22 02:24:34 geertj Exp
 */

#ifndef _IF_MEDIA_H_
#define _IF_MEDIA_H_

/*
 * Media options word:
 *	Bits	Use
 *	----	-------
 *	0-3	Media variant
 *	4	RFU
 *	5-7	Media type
 *	8-15	Type specific options
 *	16-19	RFU
 *	20-27	Shared (global) options
 *	28-31	Instance
 */

/* Ethernet */
#define IFM_ETHER	0x00000020
#define	IFM_10_T	3		/* 10BaseT - RJ45 */
#define	IFM_10_2	4		/* 10Base2 - Thinnet */
#define	IFM_10_5	5		/* 10Base5 - AUI */
#define	IFM_100_TX	6		/* 100BaseTX - RJ45 */
#define	IFM_100_FX	7		/* 100BaseFX - Fiber */
#define	IFM_100_T4	8		/* 100BaseT4 - 4 pair cat 3 */
#define	IFM_100_VG	9		/* 100VG-AnyLAN */
#define	IFM_100_T2	10		/* 100BaseT2 */
#define	IFM_1000_X	11		/* 1000BaseX - Fiber (or cable) */
#define	IFM_10_STP	12		/* 10BaseT over shielded TP */
#define	IFM_10_FL	13		/* 10BaseFL - Fiber */
#define	IFM_1000_T	14		/* 1000BaseT - Cat5 */

/* Token ring */
#define	IFM_TOKEN	0x00000040
#define	IFM_TOK_STP4	3 		/* Shielded twisted pair 4m - DB9 */
#define	IFM_TOK_STP16	4 		/* Shielded twisted pair 16m - DB9 */
#define IFM_TOK_UTP4	5		/* Unshielded twisted pair 4m - RJ45 */
#define IFM_TOK_UTP16	6		/* Unshielded twisted pair 16m - RJ45 */
#define	IFM_TOK_ETR	0x00000200	/* Early token release */
#define	IFM_TOK_SRCRT	0x00000400	/* Enable source routing features */
#define	IFM_TOK_ALLR	0x00000800	/* All routes / Single route bcast */
#define	IFM_TOK_MFA	0x00001000	/* Multicast using Functional Addrs */

/* FDDI */
#define	IFM_FDDI	0x00000060
#define	IFM_FDDI_SMF	3		/* Single-mode fiber */
#define	IFM_FDDI_MMF	4		/* Multi-mode fiber */
#define IFM_FDDI_UTP	5		/* CDDI / UTP */
#define IFM_FDDI_DA	0x00000100	/* Dual attach / single attach */

/* 802.11 XXX interface likely to change */
#define	IFM_802_11	0x00000080
#define	IFM_802_11_1	3		/* 1MB operation */
#define	IFM_802_11_2	4		/* 2MB operation */
#define	IFM_802_11_5	5		/* 5.5MB operation */
#define	IFM_802_11_11	6		/* 11MB operation */

#define	IFM_802_11_IBSS 0x00000200	/* 802.11 IBSS (ad-hoc) mode */
#define	IFM_802_11_ESS	0x00000400	/* 802.11 ESS mode */

/* Shared media sub-types */
#define	IFM_AUTO	0		/* Autoselect best media */
#define IFM_MANUAL	1		/* Jumper/dipswitch selects media */
#define	IFM_NONE	2		/* Deselect all media */

/* Shared options */
#define IFM_FDX		0x00100000	/* Force full duplex */
#define	IFM_HDX		0x00200000	/* Force half duplex */
#define	IFM_RXFLOW	0x00400000	/* RX hardware flow control */
#define	IFM_TXFLOW	0x00800000	/* TX hardware flow control */
#define IFM_FLAG0	0x01000000	/* Driver defined flag */
#define IFM_FLAG1	0x02000000	/* Driver defined flag */
#define IFM_FLAG2	0x04000000	/* Driver defined flag */
#define	IFM_LOOP	0x08000000	/* Put hardware in loopback */

/* Masks */
#define	IFM_NMASK	0x000000e0	/* Network type */
#define	IFM_TMASK	0x0000000f	/* Media sub-type */
#define	IFM_IMASK	0xf0000000	/* Instance */
#define	IFM_ISHIFT	28		/* Instance shift */
#define	IFM_OMASK	0x0000ff00	/* Type specific options */
#define	IFM_GMASK	0x0ff00000	/* Global options */

/* Status bits */
#define	IFM_AVALID	0x00000001	/* Active bit valid */
#define	IFM_ACTIVE	0x00000002	/* Interface attached to working net */

#ifdef KERNEL

typedef	void (*ifm_stat_cb_t) __P((struct ifnet *ifp, struct ifmediareq *req));
typedef	int (*ifm_change_cb_t) __P((struct ifnet *ifp));

#define IFM_TYPE(x)		((x) & IFM_NMASK)
#define IFM_SUBTYPE(x)		((x) & IFM_TMASK)
#define IFM_TYPE_OPTIONS(x)	((x) & IFM_OMASK)
#define IFM_INST(x)		(((x) & IFM_IMASK) >> IFM_ISHIFT)
#define IFM_OPTIONS(x)		((x) & (IFM_OMASK|IFM_GMASK))

#define IFM_INST_MAX		IFM_INST(IFM_IMASK)

/*
 * We have the media word in 2 places: each media entry has it and the
 * ifmedia structure itself has it. The entry in the ifmedia structure is
 * the most specific word activated by the user, the ifm_media in the
 * current (ifm_cur) ifmedia_entry may not match if ifm_mask is non-zero
 * and the user selected one of the masked bits.
 */

/* A valid combination of media options */
struct	ifmedia_entry {
	struct ifmedia_entry *ifm_next;
	int	ifm_media;		/* Media option word */
	int	ifm_data;		/* Driver private */
	void	*ifm_aux;		/* Driver private */
};

/* List head and general state, put in the driver softc */
struct ifmedia {
	int	ifm_mask;		/* Don't care mask */
	int	ifm_media;		/* Actual current media word */
	struct ifmedia_entry *ifm_cur;	/* Currently selected media entry */
	struct ifmedia_entry *ifm_list;	/* List of all media */
	ifm_change_cb_t ifm_change;	/* Media change callback */
	ifm_stat_cb_t ifm_status;	/* Media status callback */
};

void	ifmedia_init __P((struct ifmedia *mp, int mask, ifm_change_cb_t change,
    ifm_stat_cb_t status));
void	ifmedia_set __P((struct ifmedia *mp, int mword));
int	ifmedia_find __P((struct ifmedia *mp, int mword[]));
void	ifmedia_add __P((struct ifmedia *mp, int mword, int data, void *aux));
void	ifmedia_list_add __P((struct ifmedia *mp, struct ifmedia_entry *lp,
    int count));
void	ifmedia_del __P((struct ifmedia *mp, int mword));
int	ifmedia_chk __P((struct ifmedia *mp, int mword));
int	ifmedia_ioctl __P((struct ifnet *ifp, struct ifreq *ifr,
    struct ifmedia *mp, u_long cmd));
#endif

#endif /* !_IF_MEDIA_H_ */
