/*-
 * Copyright (c) 1993, 1994, 1995, 1996 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI if_p2p.h,v 2.9 1998/10/13 18:49:11 jch Exp
 */

#ifndef _IF_P2P_H_
#define _IF_P2P_H_

/*
 * The point-to-point protocols' common data structure
 */

struct p2pcom {
	struct	ifnet p2p_if;		/* network-visible interface */
	int	p2p_oldflags;		/* the old flags */
	int	(*p2p_input) __P((struct p2pcom *, struct mbuf *));
	void	(*p2p_modem) __P((struct p2pcom *, int));  /* modem event */
	int	(*p2p_mdmctl) __P((struct p2pcom *, int)); /* modem control */
	int	(*p2p_hdrinput) __P((struct p2pcom *, u_char *, int));
	int	(*p2p_getmdm) __P((struct p2pcom *, caddr_t));
	struct	p2pprotosw *p2p_proto;
	int	p2p_type;		/* current type */
	struct	ifqueue p2p_isnd;	/* queue for interactive packets */

	struct	p2pcom *p2p_next;	/* next structure in protocol's list */
	struct	p2pcom **p2p_prevp;	/* prev. structure in protocol's list */
	struct  mbuf *p2p_ibuf;		/* input mbuf */

	void	*p2p_private;		/* protocol private data */
};

/*
 * The table of available point-to-point encapsulation protocols
 */
struct p2pprotosw {
	int	pp_type;		/* interface type for ifnet */
	int	(*pp_attach)();		/* attach protocol */
	void	(*pp_detach)();		/* detach protocol */
	int	(*pp_init)();		/* protocol initialization routine */
	void	(*pp_shutdown)();	/* protocol shutdown routine */
	int	(*pp_output)();		/* output encapsulation routine */
	int	(*pp_input)();		/* the input parsing routine */
	int	(*pp_ioctl)();		/* protocol-specific ioctl */
	void	(*pp_modem)();		/* modem event */
	int	(*pp_hdrinput)();	/* header/input processing */
	int	(*pp_ctloutput)();	/* get/setsockopt processing */
	int	pp_cskip;		/* skip this much if compressed */
	u_int	pp_bpftype;		/* type to pass to bpfattach */
	int	pp_hdrlen;		/* link level header length (for bpf) */
};

/*
 * P2P_CSKIP returns the number of bytes that must be left at the
 * start of the initial data mbuf for prepending of data (uncompressed header)
 * P2P_GETMBUF get an mbuf with P2P_CSKIP bytes left for prepending
 * P2P_MBUFLEN returns space available in mbuf returned by P2P_GETMBUF
 */
#define	P2P_CSKIP(pp)	((pp)->p2p_proto->pp_cskip)
#define	P2P_GETMBUF(m, pp) { \
	MGETHDR(m, M_DONTWAIT, MT_DATA); \
	if (m) { \
		MCLGET(m, M_DONTWAIT); \
		if (m->m_flags & M_EXT) == 0) { \
			printf("P2P_GETMBUF: no space"); \
			m_freem(m); \
			m = 0; \
		} else  { \
			m->m_data += P2P_CSKIP(pp); \
			m->m_len = 0; \
		} \
	} \
}
#define	P2P_MBUFLEN(pp)	(MCLBYTES - P2P_CSKIP(pp))

/*
 * p2p_mdmctl:
 *	hook to tell the hardware to set/clear DTR
 *
 * p2p_getmdm:
 *	hook to ask the hardware the state of DCD
 *
 * the other p2p_ routines are pointers to the the
 * pp_ routines of the same name)
 *
 * pp_attach:
 *	Called when the interface is first changed to the specified type.
 *
 *	Responsible for allocating data for p2p_private.
 *
 * pp_detach:
 *	Called when the interface is changed to another type.
 *
 *	Should free p2p_private data and clear pointer.
 *
 * pp_init:
 *	Called when the interface goes from a DOWN to UP state.
 *
 * pp_shutdown:
 *	Called when the interface goes from a UP to DOWN state.
 *
 * pp_output:
 *	Called with a packet in an mbuf chain to send to the interface.
 *
 * pp_input:
 *	Called with an mbuf chain of a packet from the network.  The mbuf
 *	chain may have restrictions placed on it by the protocol.
 *	PPP requires that the first mbuf contain the link level header
 *	and any compressed header.  The second mbuf is expected to have
 *	room for pp_cskip(120) bytes to be prepended (for the uncompressed
 *	header).
 * 
 * pp_ioctl:
 *	For handling protocol specific ioctl's
 *
 * pp_modem:
 *	Called with a flag to indicate new state of DCD
 *
 * pp_hdrinput:
 *	Called with block of data from the interface (perhaps a single
 *	character) which is placed into an mbuf chain (which will meet
 *	any restrictions placed by pp_input).  It returns -1 if the
 *	input cannot be accepted for some reason, 0 if the input is
 *	accepted but more input is needed to finish initial processing
 *	(the link level header and compressed headers, for instance)
 *	and returns 1 when all remaining data is just going to be appended
 *	to the mbuf chain (so the caller can do this more efficently).
 *
 *	pp_hdrinput may be be called with nbytes == -1 to indicate that
 *	some error occured and the state should be reset (and all data
 *	processed thus far should be forgotten).
 *
 * pp_ctloutput:
 *	Called by get/setsockopt().  The level should be the link
 *	type (IFT_XXX).  level of IFT_NONE is handled by p2p_ctloutput.
 */

/* Check for limit of 2 queues */
#define IF_QFULL2(normal_q, fast_q) \
	((normal_q)->ifq_len + (fast_q)->ifq_len >= (normal_q)->ifq_maxlen)

#ifdef KERNEL
int	p2p_attach __P((struct p2pcom *));
int	p2p_ctloutput __P((int, struct ifnet *, int, int, struct mbuf **));
void	p2p_dcdchg __P((struct p2pcom *, int));
int	p2p_detach __P((struct p2pcom *));
int	p2p_init __P((struct p2pcom *));
int	p2p_ioctl __P((struct ifnet *, u_long, caddr_t));
void	p2p_shutdown __P((struct p2pcom *));
extern	struct p2pprotosw p2pprotosw[];
extern	int np2pproto;
#endif

/* sockopts for P2P interfaces */
#define P2P_DTR         0x0001  /* Set/Clear DTR */
#define P2P_DCD         0x0002  /* Get DCD */

#define ifr_p2pioctl(ifr)    ((caddr_t)&(((struct ifreq *)(ifr))->ifr_data))

#endif /* !_IF_P2P_H_ */
