/*-
 * Copyright (c) 1993, 1994, 1995, 1996 Berkeley Software Design, Inc.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI if_pif.h,v 2.6 2000/05/28 01:06:54 geertj Exp
 */

#ifndef _IF_PIF_H_
#define _IF_PIF_H_

#define	PIF_MIN_IF	4

struct pif_softc {
	struct	ifnet pif_if;
	u_int32_t pif_flags;			/* Flags: see below */
	u_short	pif_last;			/* last if we used for output */
	u_long	pif_admin_mtu;			/* Admin set max MTU value */

	u_short	pif_nif;			/* # ifs assigned to this pif */
	u_short	pif_maxif;			/* # elements in *pif_list */
	struct	ifnet **pif_list;		/* list of ifs */

	struct	ifnet *_pif_list[PIF_MIN_IF];	/* static initial pif_list */
};

#define PIF_MAX_MTU		(65*1024)
/*
 * PIF flags.
 * The PIF_MASK bits specify how to select an interface.
 * It's sort of an enumerated value, but the bottom two
 * bits have specific meanings.  We reserve a few extra
 * bits for future usage.
 */
#define	PIF_MASK		0x01f	/* reserve 5 bits */

#define PIF_RESCAN		0x01	/* not set means "round-robin" */
#define PIF_IGNORE_OACTIVE	0x02	/* not set means search for idle "if" */
#define	PIF_RESERVED1		0x04
#define	PIF_RESERVED2		0x08
#define	PIF_RESERVED3		0x10

#define	PIF_NEXT_IDLE	0					/* 0 */
#define	PIF_FIRST_IDLE	PIF_RESCAN				/* 1 */
#define	PIF_NEXT_UP	PIF_IGNORE_OACTIVE			/* 2 */
#define	PIF_FIRST_UP	(PIF_RESCAN | PIF_IGNORE_OACTIVE)	/* 3 */

#ifdef	KERNEL
LIST_HEAD(pif_head, ifnet);

void	pifattach __P((int));
int	pif_alloc __P((struct ifnet *, struct ifnet **));
int	pifioctl __P((struct ifnet *, u_long, caddr_t));
void	pifstart __P((struct ifnet *));
int	pif_add __P((struct pif_softc *, struct ifnet *));
int	pif_free __P((struct ifnet *));
int	pif_remove __P((struct pif_softc *, struct ifnet *));
void	pif_cominit __P((struct pif_softc *));
int	pifoutput __P((struct ifnet *, struct mbuf *,
	    struct sockaddr *, struct rtentry *));
int	pif_enqueue __P((struct ifnet *, struct mbuf *,
	    struct sockaddr *, struct rtentry *));
int	pif_done __P((struct ifnet *));

int	(*ppp_pif_alloc) __P((struct ifnet *, struct ifnet **));
int	(*ppp_pif_free) __P((struct ifnet *));
#endif

struct pifreq {
	char	pifr_name[IFNAMSIZ];
	union {
		char	  pifru_subname[IFNAMSIZ];
		u_int32_t pifru_flags;
	} pifr_pifru;
#define	pifr_subname	pifr_pifru.pifru_subname
#define	pifr_flags	pifr_pifru.pifru_flags
};

#define	PIFIOCADD	_IOWR('i', 200, struct pifreq)
#define	PIFIOCDEL	_IOWR('i', 201, struct pifreq)
#define	PIFIOCGFLG	_IOWR('i', 202, struct pifreq)
#define	PIFIOCSFLG	_IOWR('i', 203, struct pifreq)
#define	PIFIOCGPIF	_IOWR('i', 204, struct pifreq)

#endif /* !_IF_PIF_H_ */
