/*-
 * Copyright (c) 1993, 1994, 1995, 1996 Berkeley Software Design, Inc.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI if_ppp.h,v 2.9.20.1 2001/03/29 06:25:20 dab Exp
 */

#ifndef _IF_PPP_H_
#define _IF_PPP_H_

/*
 * This code is partially derived from CMU PPP.
 *
 * Copyright (c) 1989 Carnegie Mellon University.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Carnegie Mellon University.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/*
 * Undefine PPP_DEBUG if no debugging code is needed;
 * define it as 0 if debugging should off on default,
 * or as 1 if debugging is default.
 */
#ifndef PPP_DEBUG
#define	PPP_DEBUG 0
#endif

/*
 * The PPP definitions (RFC 1331)
 */

/*
 * Format of a PPP HDLC like header
 */
struct ppp_header {
	u_char  phdr_addr;      /* address byte */
	u_char  phdr_ctl;       /* control byte */
	u_short phdr_type;      /* protocol selector */
};

/*
 * Turn on the Multilink code by default, but allow for it
 * to be turned of via the "NOMULTILINK" config option.
 */
#ifndef NOMULTILINK
#define	MULTILINK
#endif
/*
 * PPP Multilink Protocol (MP)
 *
 * Short seq: 2 bits flags, 2 bits MBZ, 12 bits sequence number.
 * Long seq:  2 bits flags, 6 bits MBZ, 24 bits sequence number.
 */
#define	MP_FLAG_SHIFT	6

#define	MP_BEGIN	0x2
#define	MP_END		0x1

#define	MP_SSEQ_LEN	2
#define	MP_SSEQ_MASK	0xfff
#define	MP_SSEQ_SIGN	0x800
#define	MP_LSEQ_LEN	4
#define	MP_LSEQ_MASK	0xffffff
#define	MP_LSEQ_SIGN	0x800000

/* Endpoint Discriminator and Authentication information */
struct  ppp_ed {
	u_char	ed[20];		/* The Endpoint Discriminator */
	short	ed_type;	/* Endpoint Discriminator type */
	u_short	ed_len;		/* Length of discriminator */
};

struct	ppp_auth {
	u_char	auth_name[64];	/* Authentication name */
	u_short	auth_len;
};


#ifdef	KERNEL
/*
 * internal softc structure.
 */
struct ppp_sc {
	u_long	ppp_flags;
	u_short	ppp_idlecnt;		/* idle time counter */
	u_short	ppp_idletime;		/* The inactivity timer (in seconds) */
	u_char	ppp_txflags;		/* TX modes accepted by peer */
	u_long	ppp_txcmap;		/* active TX chars map */
	u_long	ppp_rxcmap;		/* active RX chars map */
	u_char	ppp_wdrop;		/* Someone's waiting for dropped */
	struct	slcompress *ppp_ctcp;	/* compressed tcp state */
	struct	ifqueue ppp_ipdefq;	/* queue for deferred outgoing IP */
	struct	mbuf *ppp_opack;	/* current mbuf being filled in */
	vjc_t	ppp_vjc;
	struct	ppp_mp *ppp_mp;		/* Shared Multilink state */
	u_int32_t ppp_seq;		/* Last seq # rcvd from this element */
	LIST_ENTRY(ppp_sc) ppp_mp_next;	/* List of ppp_scs in a MP bundle */
};

struct ppp_frag {
	LIST_ENTRY(ppp_frag) frag_next;
	u_int32_t frag_seq_first;
	u_int32_t frag_seq_last;
	short	frag_flags;
	struct	mbuf *frag_m;
};

LIST_HEAD(frag_head, ppp_frag);
LIST_HEAD(mp_head, ppp_sc);
LIST_HEAD(mp_list, ppp_mp);

struct mp_list mp_list;

struct ppp_mp {
	LIST_ENTRY(ppp_mp) mp_next;	/* List of all ppp_mp structures */
	u_int32_t mp_ref;		/* # references to this structure */
	u_int32_t mp_snd_seq;		/* Next seq # to send */
	u_int32_t mp_rcv_seq_min;	/* Min. seq # rcvd across all links */
	u_int32_t mp_rcv_seq_next;	/* Next in order sequence number */
	u_short	mp_mrru;		/* Maximum-Receive-Reconstructed-Unit */
	struct	mp_head mp_bndl;	/* List of ppp_scs in this bundle */
	struct	frag_head mp_frag;	/* Fragment/Out-of-sequence pkts */
	struct	ppp_ed mp_ed;		/* Remote Endpoint Discriminator info */
	struct	ppp_auth mp_auth;	/* Remote Authentication Information */
	struct	ifnet *mp_pif;		/* The "pif" for this bundle */
};
#endif

struct ppp_stat {
	u_quad_t ppps_mp_sseq;		/* short sequence pkts received */
	u_quad_t ppps_mp_lseq;		/* long sequence pkts received */
	u_quad_t ppps_mp_inseq;		/* in sequence pkts received */
	u_quad_t ppps_mp_wholefrag;	/* pkt received in one fragment */
	u_quad_t ppps_mp_onlyfrag;	/* added to empty frag queue */
	u_quad_t ppps_mp_firstfrag;	/* added to start of frag queue */
	u_quad_t ppps_mp_endfrag;	/* added to end of frag queue */
	u_quad_t ppps_mp_dropfrag;	/* frags dropped due to missing frag */
	u_quad_t ppps_mp_oseqfrag;	/* out-of-sequence frags processed */
	u_quad_t ppps_mp_inseqfrag;	/* in sequence frags processed */
	u_quad_t ppps_mp_longfrag;	/* Too long of fragment received */
	u_quad_t ppps_mp_mergefrag;	/* frag merged into existing frag */
	u_quad_t ppps_mp_mp;		/* MP pkt in MP pkt */
};

struct ppp_stat ppp_stat;

/* Frame encapsulation stuff */
#define PPP_ADDRESS     0xff    /* The address byte value */
#define PPP_CONTROL     0x03    /* The control byte value */

/* Protocol numbers */
#define PPP_IP          0x0021  /* Raw IP */
#define PPP_OSI         0x0023  /* OSI Network Layer */
#define PPP_NS          0x0025  /* Xerox NS IDP */
#define PPP_DECNET      0x0027  /* DECnet Phase IV */
#define PPP_APPLE       0x0029  /* Appletalk */
#define PPP_IPX         0x002b  /* Novell IPX */
#define PPP_VJC         0x002d  /* Van Jacobson Compressed TCP/IP */
#define PPP_VJNC        0x002f  /* Van Jacobson Uncompressed TCP/IP */
#define PPP_BRPDU       0x0031  /* Bridging PDU */
#define PPP_STII        0x0033  /* Stream Protocol (ST-II) */
#define PPP_VINES       0x0035  /* Banyan Vines */
#define	PPP_MP		0x003d	/* Multilink Protocol Fragment */
#define PPP_IPV6	0x0057  /* IPv6 */

#define PPP_HELLO       0x0201  /* 802.1d Hello Packets */
#define PPP_LUXCOM      0x0231  /* Luxcom */
#define PPP_SNS         0x0233  /* Sigma Network Systems */

#define PPP_IPCP        0x8021  /* IP Control Protocol */
#define PPP_OSICP       0x8023  /* OSI Network Layer Control Protocol */
#define PPP_NSCP        0x8025  /* Xerox NS IDP Control Protocol */
#define PPP_DECNETCP    0x8027  /* DECnet Control Protocol */
#define PPP_APPLECP     0x8029  /* Appletalk Control Protocol */
#define PPP_IPXCP       0x802b  /* Novell IPX Control Protocol */
#define PPP_STIICP      0x8033  /* Stream Protocol Control Protocol */
#define PPP_VINESCP     0x8035  /* Banyan Vines Control Protocol */
#define PPP_IPV6CP	0x8057  /* IPv6 Control Protocol */

#define PPP_LCP         0xc021  /* Link Control Protocol */
#define PPP_PAP         0xc023  /* Password Authentication Protocol */
#define PPP_LQM         0xc025  /* Link Quality Monitoring */
#define PPP_CHAP        0xc223  /* Challenge Handshake Authentication Protocol*/

/* FSM id numbers */
#define	FSM_LCP		0
#define	FSM_IPCP	1
#define	FSM_PAP		2

/* Option parsing result */
#define	OPT_OK		0
#define	OPT_REJ		1
#define	OPT_NAK		2
#define	OPT_FATAL	3

#define PPPMTU	1500		/* MTU for sync lines */
#define	PPPMRRU	1600		/* Default MRU for PPP Multilink */

/*
 * When debugging, the following packet types can be sent up the raw link
 * layer.  The first three are sent on a corrupt packet.
 */
#define PPPD_SKIP	0x0000	/* skipping until flag */
#define PPPD_OK		0x0001	/* waiting for data */
#define PPPD_ESC	0x0002	/* got an escape */
#define	PPPD_PKTSENT	0x0003	/* debug info on packet sent out interface */
#define	PPPD_PKTRECV	0x0004	/* debug info on packet received on interface */

#if defined(KERNEL) && defined(MULTILINK)
struct p2pcom;
int     (*ppp_mp_ioctl) __P((struct p2pcom *, int, caddr_t));
void    (*ppp_mp_detach) __P((struct p2pcom *, struct ppp_sc *));
int     (*ppp_mp_reass) __P((struct p2pcom *, struct mbuf *));
#endif

#endif /* !_IF_PPP_H_ */
