/*
 * Copyright (c) 1988, Julian Onions <jpo@cs.nott.ac.uk>
 * Nottingham University 1987.
 *
 * This source may be freely distributed, however I would be interested
 * in any changes that are made.
 *
 * This driver takes packets off the IP i/f and hands them up to a
 * user process to have it's wicked way with. This driver has it's
 * roots in a similar driver written by Phil Cockcroft (formerly) at
 * UCL. This driver is based much more on read/write/select mode of
 * operation though.
 * 
 * from: $Header: if_tnreg.h,v 1.1.2.1 1992/07/16 22:39:16 friedl Exp
 * if_tun.h,v 1.2 1996/08/13 02:52:46 jch Exp
 */

#ifndef _NET_IF_TUN_H_
#define _NET_IF_TUN_H_

/* Maximum packet size */
#define	TUNMTU		1500

/* ioctl's for get/set debug */
#define	TUNSDEBUG	_IOW('T', 100, int)
#define	TUNGDEBUG	_IOR('T', 101, int)
#define	TUNSIFINFO	_IOW('T', 102, struct tuninfo)
#define	TUNGIFINFO	_IOR('T', 103, struct tuninfo)

struct tuninfo {
	int	baudrate;		/* linespeed */
	short	mtu;			/* maximum transmission unit */
	u_char	type;			/* ethernet, tokenring, etc. */
	u_char	dummy;			/* place holder */
};
#endif /* !_NET_IF_TUN_H_ */
