/*
 * Copyright (c) University of British Columbia, 1984
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * the Laboratory for Computation Vision and the Computer Science Department
 * of the University of British Columbia.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)x25acct.h	8.1 (Berkeley) 6/10/93
 */

#ifndef _NETCCITT_X25ACCT_H_
#define _NETCCITT_X25ACCT_H_

/*
 * Format of X.25 accounting record written
 * to X25ACCTF whenever a circuit is closed.
 */

#ifdef waterloo
#define X25ACCTF	"/usr/adm/logs/x25acct"
#else
#define X25ACCTF	"/usr/adm/x25acct"
#endif

struct	x25acct {
	time_t	x25acct_stime;		/* start time */
#ifdef waterloo
	u_long	x25acct_etime;		/* elapsed time (seconds) */
#else
	u_short	x25acct_etime;		/* elapsed time (seconds) */
#endif
	short	x25acct_uid;		/* user id */
	short	x25acct_net;		/* network id */
	u_short	x25acct_psize:4,	/* packet size */
		x25acct_addrlen:4,	/* x25acct_addr length */
		x25acct_revcharge:1,	/* reverse charging */
		x25acct_callin:1,	/* incoming call */
		x25acct_unused:6;
	char	x25acct_addr[8];	/* remote DTE address (in bcd) */
	char	x25acct_udata[4];	/* protocol id */
	long	x25acct_txcnt;		/* packets transmitted */
	long	x25acct_rxcnt;		/* packets received */
};

#endif /* !_NETCCITT_X25ACCT_H_ */
