/*	BSDI icmp_var.h,v 2.11 1999/08/06 21:19:43 dab Exp	*/

/*
 * Copyright (c) 1982, 1986, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)icmp_var.h	8.1 (Berkeley) 6/10/93
 */

#ifndef _ICMP_VAR_H_
#define _ICMP_VAR_H_

/*
 * Variables related to this implementation
 * of the internet control message protocol.
 */
struct	icmpstat {
/* statistics related to icmp packets generated */
	u_quad_t icps_error;		/* # of calls to icmp_error */
	u_quad_t icps_oldshort;		/* no error 'cuz old ip too short */
	u_quad_t icps_oldicmp;		/* no error 'cuz old was icmp */
	u_quad_t icps_outhist[ICMP_MAXTYPE + 1];
/* statistics related to input messages processed */
 	u_quad_t icps_badcode;		/* icmp_code out of range */
	u_quad_t icps_tooshort;		/* packet < ICMP_MINLEN */
	u_quad_t icps_checksum;		/* bad checksum */
	u_quad_t icps_badlen;		/* calculated bound mismatch */
	u_quad_t icps_reflect;		/* number of responses */
	u_quad_t icps_inhist[ICMP_MAXTYPE + 1];
	u_quad_t icps_bogusfrag;	/* Bogus FRAG NEEDED message */
	u_quad_t icps_bmcastecho;	/* broadcast echo requests ignored */
	u_quad_t icps_badaddr;		/* Bad return address */
	u_quad_t icps_noroute;		/* No route back */
};

/*
 * Names for ICMP sysctl objects
 */
#define	ICMPCTL_MASKREPL	1	/* allow replies to netmask requests */
#define	ICMPCTL_REDIRACCEPT	2	/* accept/process redirects */
#define	ICMPCTL_REDIRTIMEOUT	3	/* redirect cache time */
#define	ICMPCTL_PRINTFS		4	/* redirect cache time */
#define	ICMPCTL_STATS		5	/* statistics */
#define	ICMPCTL_BMCASTECHO	6	/* allow replies to broadcast echo req*/
#define ICMPCTL_MAXID		7

#define ICMPCTL_NAMES { \
	{ 0, 0 }, \
	{ "maskrepl", CTLTYPE_INT }, \
	{ "rediraccept", CTLTYPE_INT }, \
	{ "redirtimeout", CTLTYPE_INT }, \
	{ "printfs", CTLTYPE_INT }, \
	{ "stats", CTLTYPE_STRUCT }, \
	{ "bmcastecho", CTLTYPE_INT }, \
}

#ifdef	ICMPPRINTFS
#define	__ICMPPRINTFS	&icmpprintfs
#else
#define	__ICMPPRINTFS	0
#endif

#define	ICMPCTL_VARS { \
	0, \
	&icmpmaskrepl, \
	&icmp_rediraccept, \
	&icmp_redirtimeout, \
	__ICMPPRINTFS, \
	0, \
	&icmpbmcastecho, \
}

#ifdef KERNEL
int	icmp_rediraccept;		/* accept/process redirects */
int	icmp_redirtimeout;		/* cache time for redirect routes */
struct	icmpstat icmpstat;
#endif

#endif /* !_ICMP_VAR_H_ */
