/*
 * Copyright (c) 1996, 1997 Berkeley Software Design, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that this notice is retained,
 * the conditions in the following notices are met, and terms applying
 * to contributors in the following notices also apply to Berkeley
 * Software Design, Inc.
 *
 *	BSDI in_pcb.h,v 2.9.6.4 2001/09/07 19:35:57 dab Exp
 */

/*
 * Copyright (c) 1982, 1986, 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)in_pcb.h	8.1 (Berkeley) 6/10/93
 */

#ifndef _NETINET_IN_PCB_H_
#define _NETINET_IN_PCB_H_

#include <sys/queue.h>

/*
 * Common structure pcb for internet protocol implementation.
 * Here are stored pointers to local and foreign host table
 * entries, local and foreign socket numbers, and pointers
 * up (to a socket structure) and down (to a protocol-specific)
 * control block.
 */

/*
 * If INET6 is being used, anything that uses in_pcb.h will also have to
 * include:
 *
 *		netinet6/in6.h
 *		netinet6/ipv6.h
 *		netinet6/ipv6_var.h
 *
 * These files are wrapped in ifdefs.  Perhaps putting in6.h in with in.h, and
 * correspondingly ipv6.h with ip.h, etc. may be better.
 */

#include <netinet/in.h>
#include <netinet/ip6.h>
#include <netinet6/ip6_var.h>
#include <netinet/icmp6.h>

#if 1 /*IPSEC*/
#include <netinet6/ipsec.h>
#endif

union inpaddru {
	struct in6_addr iau_addr6;
	struct {
		u_int8_t pad[12];
		/* I put the in_addr here because this makes */
		/* transition easier. */
		struct in_addr inaddr;
	} iau_a4u;
};

struct inpcb {
	struct	inpcb *inp_next, *inp_prev;
					/* To others in 2-way linked list. */
	LIST_ENTRY(inpcb) inp_hlist;	/* hash chain */
	u_long	inp_hash;		/* hash value */
	struct	inpcb *inp_head;	/* Back pointer to list head. */
	struct	socket *inp_socket;	/* Back pointer to socket. */

	union	inpaddru inp_faddru;	/* Foreign address. */
	union	inpaddru inp_laddru;	/* Local address. */

#define inp_faddr  inp_faddru.iau_a4u.inaddr
#define inp_faddr6 inp_faddru.iau_addr6
#define inp_laddr  inp_laddru.iau_a4u.inaddr
#define inp_laddr6 inp_laddru.iau_addr6

	caddr_t inp_ppcb;		/* Pointer to per-protocol pcb */

	struct route inp_route;
#define inp_route6 inp_route /* XXX */


	union {				/* Header prototype. */
	      struct ip hu_ip;
	      struct ip6_hdr hu_ipv6;
	} inp_hu;
#define inp_ip inp_hu.hu_ip
#define inp_ipv6 inp_hu.hu_ipv6

	union {
		struct ip_moptions *mou_mo;	/* IP multicast options. */
		struct ip6_moptions *mou_mo6;	/* IPv6 multicast options. */
	} inp_mou;
#define inp_moptions inp_mou.mou_mo
#define inp_moptions6 inp_mou.mou_mo6
	int inp_flags;			/* PCB flags. */
	u_short inp_fport;		/* Foreign port. */
	u_short inp_lport;		/* Local port. */
#define	inp_flowinfo	inp_hu.hu_ipv6.ip6_flow

	int	in6p_cksum;
#ifndef _KERNEL
#define inp_csumoffset in6p_cksum
#endif
	struct icmp6_filter *inp_icmp6filt;

	struct mbuf *inp_options;	/* IPv4 options mbuf chain. */
	struct ip6_recvpktopts *inp_inputopts6;
	struct ip6_pktopts *inp_outputopts6; /* IP6 opts for outgoing pkts */
	int inp_hops;

#if 1 /*KAME IPsec*/
	struct inpcbpolicy *inp_sp;	/* security policy. */
#endif
};

/* flags in inp_flags: */
#define	INP_RECVOPTS		0x01	/* receive incoming IP options */
#define	INP_RECVRETOPTS		0x02	/* receive IP options for reply */
#define	INP_RECVDSTADDR		0x04	/* receive IP dst address */
#define	INP_HDRINCL		0x08	/* user supplies entire IP header */
#define	INP_ONESBCAST		0x10	/* broadcast with all ones address */

#define	INP_RXDSTOPTS		INP_RECVOPTS
#define	INP_RXHOPOPTS		INP_RECVRETOPTS
#define	INP_RXINFO		INP_RECVDSTADDR
#define	INP_RXSRCRT		0x10
#define	INP_HOPLIMIT		0x20

#define	INP_CONTROLOPTS		(INP_RECVOPTS|INP_RECVRETOPTS|\
				 INP_RECVDSTADDR|INP_RXSRCRT|INP_HOPLIMIT)

/*
 * These flag values should be determined by either the transport
 * protocol at PRU_BIND, PRU_LISTEN, PRU_CONNECT, etc, or by in_pcb*().
 */
#define	INP_IPV6	0x100	/* This flag is set iff */
				/* sotopf(inp->inp_socket) == PF_INET6.  */
#define	INP_IPV6_UNDEC	0x200	/* PCB is an PF_INET6 PCB, but */
				/* listening for both v4 and v6. */
#define	INP_IPV6_MAPPED	0x400	/* PF_INET6 PCB which is connected to */
				/* an IPv4 host, or is bound to */
				/* an IPv4 address (specified with */
				/* the mapped form of v6 addresses). */
/*
 * This flag is to prevent confusion in multicast options.
 * XXX Note from KAME: why is this flag needed? why not just check
 *     the type of inp_socket? One possibility would be to allow a user
 *     to handle IPv4 multicasting on an AF_INET6 socket, but we'd need
 *     more work to accomplish such stuff.
 *     For now, we'll keep this anyway, but we'd like to nuke the flag.
 */
#define	INP_IPV6_MCAST	0x800	/* Only set if inp_moptions points */
				/* to IPv6 multicast options. */

#if 1	/*KAME*/
/*
 * Flags in in6p_flags
 * We define KAME's original flags in higher 16 bits as much as possible
 * for compatibility with *bsd*s.
 */
#define IN6P_IPV6_V6ONLY	0x008000 /* restrict AF_INET6 socket for v6 */
#define IN6P_PKTINFO		0x010000 /* receive IP6 dst and I/F */
#define IN6P_HOPLIMIT		0x020000 /* receive hoplimit */
#define IN6P_HOPOPTS		0x040000 /* receive hop-by-hop options */
#define IN6P_DSTOPTS		0x080000 /* receive dst options after rthdr */
#define IN6P_RTHDR		0x100000 /* receive routing header */
#define IN6P_RTHDRDSTOPTS	0x200000 /* receive dstoptions before rthdr */
#define IN6P_TCLASS		0x400000 /* receive traffic class value */
#define IN6P_AUTOFLOWLABEL	0x800000 /* attach flowlabel automatically */

#define IN6P_HIGHPORT		0x1000000 /* user wants "high" port binding */
#define IN6P_LOWPORT		0x2000000 /* user wants "low" port binding */
#define IN6P_ANONPORT		0x4000000 /* port chosen for user */
#define IN6P_FAITH		0x8000000 /* accept FAITH'ed connections */
#define IN6P_MINMTU		0x20000000 /* use minimum MTU */
#define IN6P_RFC2292		0x40000000 /* used RFC2292 API on the socket */
#define IN6P_MTU		0x80000000 /* receive path MTU */

#define IN6P_CONTROLOPTS	(IN6P_PKTINFO|IN6P_HOPLIMIT|IN6P_HOPOPTS|\
				 IN6P_DSTOPTS|IN6P_RTHDR|IN6P_RTHDRDSTOPTS|\
				 IN6P_TCLASS|IN6P_AUTOFLOWLABEL|\
				 IN6P_MTU|IN6P_RFC2292)
#endif

#ifdef notdef	/*don't reuse, just in case*/
#define	INPLOOKUP_WILDCARD	1
#endif
#define	INPLOOKUP_SETLOCAL	2
#define INPLOOKUP_IPV6		4	/* addr ptrs are in6_addr not in_addr */
#define INPLOOKUP_WILDCARD4	8
#define INPLOOKUP_WILDCARD6	16
#define INPLOOKUP_WILDCARD	(INPLOOKUP_WILDCARD4 | INPLOOKUP_WILDCARD6)
#define	INPLOOKUP_FAITH		32


/* compute hash value for foreign and local in_addr and port */
#define IN_HASH(faddr, fport, laddr, lport) \
	(((faddr)->s_addr ^ (laddr)->s_addr) + (fport) + (lport))

#define IN6_HASH(faddr, fport, laddr, lport) \
	(((faddr)->s6_addr32[3] ^ (laddr)->s6_addr32[3]) + (fport) + (lport))

#define	sotoinpcb(so)	((struct inpcb *)(so)->so_pcb)

#ifdef KERNEL
/* Macro to determine protocol family of socket. */
#define sotopf(so)  (so->so_proto->pr_domain->dom_family)

int	 in_losing __P((struct inpcb *));
int	 in_pcballoc __P((struct socket *, struct inpcb *));
int	 in_pcbbind __P((struct inpcb *, struct mbuf *));
int	 in_pcbconnect __P((struct inpcb *, struct mbuf *));
int	 in_pcbdetach __P((struct inpcb *));
int	 in_pcbdisconnect __P((struct inpcb *));
struct inpcb *
	 in_pcblookup __P((struct inpcb *,
	    struct in_addr *, u_int, struct in_addr *, u_int, int));
int	in_pcbnotify __P((struct inpcb *, struct sockaddr *,
	    u_int, struct in_addr, u_int, int, void (*)(struct inpcb *, int)));
void	 in_rtchange __P((struct inpcb *, int));
int	 in_setpeeraddr __P((struct inpcb *, struct mbuf *));
int	 in_setsockaddr __P((struct inpcb *, struct mbuf *));
extern struct sockaddr_in *in_selectsrc __P((struct sockaddr_in *,
	struct route *, int, struct ip_moptions *, int *));

/* INET6 stuff */
int	in6_pcbnotify __P((struct inpcb *, struct sockaddr *,
			   u_int, struct sockaddr *, u_int, int, void *,
			   void (*)(struct inpcb *, int)));
struct 	in6_addr *in6_selectsrc __P((struct sockaddr_in6 *,
				     struct ip6_pktopts *,
				     struct ip6_moptions *,
				     struct route *,
				     struct in6_addr *, int *));
int	in6_selecthlim __P((struct inpcb *, struct ifnet *));
int	in6_setsockaddr __P((struct inpcb *, struct mbuf *));
int	in6_setpeeraddr __P((struct inpcb *, struct mbuf *));
#endif

#endif /* !_NETINET_IN_PCB_H_ */
