/*	BSDI in_var.h,v 2.12 2000/04/21 07:44:13 dab Exp	*/

/*
 * Copyright (c) 1985, 1986, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)in_var.h	8.2 (Berkeley) 1/9/95
 */

#ifndef _NETINET_IN_VAR_H_
#define _NETINET_IN_VAR_H_

/*
 * Structure for hashing "local" IP addresses for lookup
 * in IP input.  We use a singly-linked list to save space,
 * as this fits in 16 bytes on a 32-bit machine.
 */
struct inhash {
	struct	inhash *inh_next;
	struct	in_addr inh_addr;
	struct	in_ifaddr *inh_ifa;
	int	inh_flags;
};

/* inh_flags: */
#define	INH_BCAST	1	/* Is a broadcast address */
#define	INH_LBCAST	2	/* Is a limited broadcast address */

/*
 * Interface address, Internet version.  One of these structures
 * is allocated for each interface with an Internet address.
 * The ifaddr structure contains the protocol-independent part
 * of the structure and is assumed to be first.
 */
struct in_ifaddr {
	struct	ifaddr ia_ifa;		/* protocol-independent info */
#define	ia_ifp		ia_ifa.ifa_ifp
#define ia_flags	ia_ifa.ifa_flags
	struct	in_ifaddr *ia_next;	/* next in list of internet addresses */
	struct	sockaddr_in ia_addr;	/* reserve space for interface name */
	struct	sockaddr_in ia_dstaddr; /* reserve space for broadcast addr */
#define	ia_broadaddr	ia_dstaddr
	struct	sockaddr_in ia_sockmask; /* reserve space for general netmask */
	LIST_HEAD(, in_multi) ia_multiaddr_head; /* list of multicast addresses */
#define	ia_multiaddrs	ia_multiaddr_head.lh_first
	struct inhash 	ia_hash;	/* hash for ia_addr */
	struct inhash 	ia_bcasthash[2];	/* hash for broadcast addresses */
};

struct	in_aliasreq {
	char	ifra_name[IFNAMSIZ];		/* if name, e.g. "en0" */
	struct	sockaddr_in ifra_addr;
	struct	sockaddr_in ifra_broadaddr;
#define ifra_dstaddr ifra_broadaddr
	struct	sockaddr_in ifra_mask;
};
/*
 * Given a pointer to an in_ifaddr (ifaddr),
 * return a pointer to the addr as a sockaddr_in.
 */
#define	IA_SIN(ia) (&(((struct in_ifaddr *)(ia))->ia_addr))

/*
 * Determine if the address is on the same subnet as the
 * specified interface.
 */
#define	IA_ONNET(ifa, a) \
	(((((struct in_ifaddr *)ifa)->ia_addr.sin_addr.s_addr ^ ((a).s_addr)) &	\
	((struct in_ifaddr *)ifa)->ia_sockmask.sin_addr.s_addr) == 0)


#ifdef	KERNEL
extern	struct in_ifaddr *in_ifaddr;
extern	struct ifqueue	ipintrq;		/* ip packet input queue */
extern	struct ifqueue	ip6intrq;		/* ipv6 packet input queue */
extern	struct inhash *inhash[];		/* ipv4 local address hash */
extern	int in_nhash;

struct	inhash *inh_lookup __P((struct in_addr addr, struct ifnet *ifp));
struct	inhash *inh_lookup_bcast __P((struct in_addr addr));
void	inh_hashinit __P((void));
void	in_socktrim __P((struct sockaddr_in *));


/*
 * Macro for finding the interface (ifnet structure) corresponding to one
 * of our IP addresses.
 */
#define INADDR_TO_IFP(addr, ifp) \
	/* struct in_addr addr; */ \
	/* struct ifnet *ifp; */ \
{ \
	register struct inhash *ih; \
\
        if ((ih = inh_lookup(addr, NULL)) != NULL && \
	    (ih->inh_flags & INH_LBCAST) == 0) \
		ifp = ih->inh_ifa->ia_ifp; \
	else \
		ifp = NULL; \
}

/*
 * Macro for finding the interface (ifnet structure) corresponding to one
 * of our IP addresses.  Looks at the remote address of POINTOPOINT
 * interfaces 
 */
#define IFADDR_TO_IFP(addr, ifp) \
	/* struct in_addr addr; */ \
	/* struct ifnet  *ifp;  */ \
{ \
	register struct in_ifaddr *ia; \
 \
	for (ia = in_ifaddr; \
	     ia != NULL; \
	     ia = ia->ia_next) \
	    if (((struct sockaddr_in *) \
		 ((ia->ia_ifp->if_flags & IFF_POINTOPOINT) ? \
		&ia->ia_dstaddr : &ia->ia_addr))->sin_addr.s_addr == \
		(addr).s_addr) \
	        break; \
	(ifp) = (ia == NULL) ? NULL : ia->ia_ifp; \
}

/*
 * Macro for finding the internet address structure (in_ifaddr) corresponding
 * to a given interface (ifnet structure).
 */
#define IFP_TO_IA(ifp, ia) \
	/* struct ifnet *ifp; */ \
	/* struct in_ifaddr *ia; */ \
{ \
	for ((ia) = (struct in_ifaddr *)(ifp)->if_addrlist; \
	     (ia) != NULL && (ia)->ia_ifa.ifa_addr != NULL \
	     && (ia)->ia_addr.sin_family != AF_INET; \
	    (ia) = (struct in_ifaddr *)(ia)->ia_ifa.ifa_next) \
		continue; \
}
#endif

/*
 * Per-interface router version information is kept in this list.
 * This information should be part of the ifnet structure but we don't wish
 * to change that - as it might break a number of things
 */

struct router_info {
	struct ifnet *ifp;
	int    type; /* type of router which is querier on this interface */
	int    time; /* # of slow timeouts since last old query */
	struct router_info *next;
};

/*
 * Multi-cast membership entry.  One for each group/ifp that a PCB
 * belongs to.
 */
struct in_multi_mship {
	struct	ip_mreq imm_mreq;	/* Copy of request */
	struct	ifnet *imm_ifp;		/* Pointer to interface */
	struct	in_multi *imm_maddr;	/* Multicast address pointer */
	LIST_ENTRY(in_multi_mship) imm_optchain;  /* multicast options chain */
	LIST_ENTRY(in_multi_mship) imm_addrchain; /* multicast address chain */
};

/*
 * Internet multicast address structure.  There is one of these for each IP
 * multicast group to which this host belongs on a given network interface.
 * They are kept in a linked list, rooted in the interface's in_ifaddr
 * structure.
 */

struct in_multi {
	struct	in_addr inm_addr;	/* IP multicast address             */
	struct	ifnet *inm_ifp;		/* back pointer to ifnet            */
	u_short	inm_refcount;		/* no. membership claims by sockets */
	u_short inm_state;		/*  state of the membership */
	LIST_HEAD(, in_multi_mship) inm_members;  /* membership requestors */
	u_int	inm_timer;		/* IGMP membership report timer     */
	LIST_ENTRY(in_multi) inm_chain;	/* chain off of in_ifaddr */
#define	inm_next	inm_chain.le_next
	struct	router_info *inm_rti;	/* router info */
};

#ifdef KERNEL
/*
 * Structure used by macros below to remember position when stepping through
 * all of the in_multi records.
 */
struct in_multistep {
	struct in_ifaddr *i_ia;
	struct in_multi *i_inm;
};

/*
 * Macro for looking up the in_multi record for a given IP multicast address
 * on a given interface.  If no matching record is found, "inm" returns NULL.
 */
#define IN_LOOKUP_MULTI(addr, ifp, inm) \
	/* struct in_addr addr; */ \
	/* struct ifnet *ifp; */ \
	/* struct in_multi *inm; */ \
{ \
	register struct in_ifaddr *ia; \
\
	IFP_TO_IA((ifp), ia); \
	if (ia == NULL) \
		(inm) = NULL; \
	else \
		for ((inm) = ia->ia_multiaddrs; \
		    (inm) != NULL && (inm)->inm_addr.s_addr != (addr).s_addr; \
		     (inm) = inm->inm_next) \
			 continue; \
}

/*
 * Macro to step through all of the in_multi records, one at a time.
 * The current position is remembered in "step", which the caller must
 * provide.  IN_FIRST_MULTI(), below, must be called to initialize "step"
 * and get the first record.  Both macros return a NULL "inm" when there
 * are no remaining records.
 */
#define IN_NEXT_MULTI(step, inm) \
	/* struct in_multistep  step; */ \
	/* struct in_multi *inm; */ \
{ \
	if (((inm) = (step).i_inm) != NULL) \
		(step).i_inm = (inm)->inm_next; \
	else \
		while ((step).i_ia != NULL) { \
			(inm) = (step).i_ia->ia_multiaddrs; \
			(step).i_ia = (step).i_ia->ia_next; \
			if ((inm) != NULL) { \
				(step).i_inm = (inm)->inm_next; \
				break; \
			} \
		} \
}

#define IN_FIRST_MULTI(step, inm) \
	/* struct in_multistep step; */ \
	/* struct in_multi *inm; */ \
{ \
	(step).i_ia = in_ifaddr; \
	(step).i_inm = NULL; \
	IN_NEXT_MULTI((step), (inm)); \
}

int	in_ifinit __P((struct ifnet *,
	    struct in_ifaddr *, struct sockaddr_in *, int));
struct	in_multi *in_addmulti __P((struct in_addr *, struct ifnet *));
void	in_delmulti __P((struct in_multi *, struct in_ifaddr *));
void	in_ifscrub __P((struct ifnet *, struct in_ifaddr *));
int	in_control __P((struct socket *, u_long, caddr_t, struct ifnet *));
void	in_pfctlinput __P((int, struct sockaddr *, void *));
#ifdef	__STDC__
struct	inpcb;
#endif
void	in_mrejoin __P((struct inpcb *));
#endif

/* INET6 stuff */
#include <netinet6/in6_var.h>

#endif /* !_NETINET_IN_VAR_H_ */
