/*-
 * Copyright (c) 1997,1998 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI ip_rate.h,v 2.3 1999/07/27 16:55:04 prb Exp
 */

#define MAXQUE  0x7fff          /* Longest que length we allow */

#define	IPRQ_MAXNAME	16

/*
 * The rate queue structure
 */
struct ip_rateq {
	int	iprq_type;
	char	iprq_name[IPRQ_MAXNAME];
	int	iprq_chain;
	int	iprq_index;
	int     (*iprq_f)(/* struct ip_rateq *, struct ifnet *, struct mbuf *,
			    struct sockaddr *, struct rtentry * */);
	void	(*iprq_remove)(/* struct ip_rateq * */);
	int     (*iprq_ctl)(/* struct ip_rateq *, int *, u_int, void *,
			      size_t *, void *, size_t */);
	struct ifqueue iprq_q;
};

/*
 * Generic statistics.
 * Individual rate filtering types may increase the size
 */
struct iprq_ratestats {
	int	iprs_type;	/* Type of rate filter these came from */
	int	iprs_length;	/* Length of this entry */
	int	iprs_index;	/* Index of rate filter these came from */
	quad_t	iprs_passthru;	/* Number of bytes passed through */
	quad_t	iprs_delayed;	/* Number of bytes delayed */
	quad_t	iprs_relayed;	/* Number of bytes sent afer delayed */
	quad_t	iprs_dropped;	/* Number of bytes dropped */
	quad_t	iprs_ifdropped;	/* Number of bytes dropped by interface */
	struct	timeval iprs_last;/* time we last processed the queue */
	int	iprs_qlen;	/* length of queue */
	int	iprs_qleft;	/* packets left on queue */
};

/*
 * When an array of statistics are retrieved each iprq_ratestats structure
 * is preceeded by the following header.
 */
struct iprq_ratestatlist {
	u_short	iprs_index;	/* Which filter these statistics came from */
	u_short	iprs_length;	/* Length of the following statistics */
};

/*
 * The various filtering types are defined by an array of iprq_switch
 * structures.  The only entry point needed is the sysctl interface for
 * the filtering type.
 */
struct iprq_switch {
	int     iprsw_type;
	int	(*iprsw_allocate) __P((void **, int));
};

/*
 * Header placed on each packet prior to stuffing it on the queue
 */
struct iprq_hdr { 
	struct ifnet *iprh_ifp;
	struct rtentry *iprh_rt;
	struct sockaddr iprh_dst;
};      

#define	IRCTL_TYPE	1	/* Set retrieve type of rate filter */
#define	IRCTL_PARAMS	2	/* (re)initialize rate filter */
#define	IRCTL_STATS	3	/* retrieve stats */
#define	IRCTL_NAME	4	/* set/retrieve name */

#define	IRTYPE_BANDWIDTH	1	/* Classic bandwidth filter */

extern struct iprq_switch iprq_switch[];
