/*	BSDI ip_var.h,v 2.24.6.1 2001/03/29 06:40:46 dab Exp	*/

/*
 * Copyright (c) 1982, 1986, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)ip_var.h	8.2 (Berkeley) 1/9/95
 */

#ifndef _NETINET_IP_VAR_H_
#define _NETINET_IP_VAR_H_

#include <sys/queue.h>

/*
 * Overlay for ip header used by other protocols (tcp, udp).
 * (Really just so that the x0+x1 fields can be zero'd for checksumming,
 * without fixing all the other code.)
 */
struct ipovly {
	u_int32_t ih_x00;		/* (unused / set to 0) */
	u_int32_t ih_x01;		/* (unused / set to 0) */
	u_int8_t  ih_x1;		/* (unused / set to 0) */
	u_int8_t  ih_pr;		/* protocol */
	u_int16_t ih_len;		/* protocol length */
	struct	  in_addr ih_src;	/* source internet address */
	struct	  in_addr ih_dst;	/* destination internet address */
};

/*
 * IP reassembly queue structure.  Each fragment
 * being reassembled is attached to one of these structures.
 * They are timed out after ipq_ttl drops to 0, and may also
 * be reclaimed if memory becomes tight.
 */
struct fqent {
	LIST_ENTRY(fqent) fqe_q;	/* other fragments of this packet */
	struct mbuf *fqe_m;		/* this fragment's data */
	struct ip *fqe_ip;		/* IP hdr for this fragment */
#define	ip_mff ip_tos			/* overlay ip_tos: use low bit to */
					/* avoid destroying tos; copied */
					/* from (ip_off & IP_MF) */
};
struct ipq {
	TAILQ_ENTRY(ipq) ipq_q;		/* other reassembly queues */
	u_int8_t  ipq_ttl;		/* time for this reass q to live */
	u_int8_t  ipq_p;		/* protocol of this fragment */
	u_int16_t ipq_id;		/* sequence id for reassembly */
	LIST_HEAD(, fqent) ipq_fragq;	/* the fragment queue itself */
	struct	  in_addr ipq_src,ipq_dst;
};

/*
 * Structure stored in mbuf in inpcb.ip_options
 * and passed to ip_output when ip options are in use.
 * The actual length of the options (including ipopt_dst)
 * is in m_len.
 */
#define MAX_IPOPTLEN	40

struct ipoption {
	struct	in_addr ipopt_dst;	/* first-hop dst if source routed */
	char	ipopt_list[MAX_IPOPTLEN];	/* options proper */
};
#define IP_OPTLEN(m) \
	((m) ? ((m)->m_len - sizeof(((struct ipoption *)0)->ipopt_dst)) : 0)

/*
 * Structure attached to inpcb.ip_moptions and
 * passed to ip_output when IP multicast options are in use.
 */
struct ip_moptions {
	struct	ifnet *imo_multicast_ifp; /* ifp for outgoing multicasts */
	struct in_addr imo_multicast_addr; /* ifindex/addr on MULTICAST_IF */
	u_char	imo_multicast_ttl;	/* TTL for outgoing multicasts */
	u_char	imo_multicast_loop;	/* 1 => hear sends if a member */
	LIST_HEAD(, in_multi_mship) imo_memberships;	/* pcb list */
};

struct	ipstat {
	u_quad_t ips_total;		/* total packets received */
	u_quad_t ips_badsum;		/* checksum bad */
	u_quad_t ips_tooshort;		/* packet too short */
	u_quad_t ips_toosmall;		/* not enough data */
	u_quad_t ips_badhlen;		/* ip header length < data size */
	u_quad_t ips_badlen;		/* ip length < ip header length */
	u_quad_t ips_fragments;		/* fragments received */
	u_quad_t ips_fragdropped;	/* frags dropped (dups, out of space) */
	u_quad_t ips_fragtimeout;	/* fragments timed out */
	u_quad_t ips_forward;		/* packets forwarded */
	u_quad_t ips_cantforward;	/* packets rcvd for unreachable dest */
	u_quad_t ips_redirectsent;	/* packets forwarded on same net */
	u_quad_t ips_noproto;		/* unknown or unsupported protocol */
	u_quad_t ips_delivered;		/* datagrams delivered to upper level*/
	u_quad_t ips_localout;		/* total ip packets generated here */
	u_quad_t ips_odropped;		/* lost packets due to nobufs, etc. */
	u_quad_t ips_reassembled;	/* total packets reassembled ok */
	u_quad_t ips_fragmented;	/* datagrams sucessfully fragmented */
	u_quad_t ips_ofragments;	/* output fragments created */
	u_quad_t ips_cantfrag;		/* don't fragment flag was set, etc. */
	u_quad_t ips_badoptions;	/* error in option processing */
	u_quad_t ips_noroute;		/* packets discarded due to no route */
	u_quad_t ips_badvers;		/* ip version != 4 */
	u_quad_t ips_rawout;		/* total raw ip packets generated */
	u_quad_t ips_badsrcintf;	/* incorrect source interface or no route */
	u_quad_t ips_fragoverflow;	/* fragments that exceeded limit */
	u_quad_t ips_rejected;		/* packets rejected by ip filters */
	u_quad_t ips_rfc1858;		/* packets rejected by RFC 1858 */
	u_quad_t ips_nogif;		/* no match gif found */
	u_quad_t ips_badaddr;		/* invalid address on header */
};

#ifdef KERNEL
/* flags passed to ip_output as last parameter */
#define	IP_FORWARDING		0x1		/* most of ip header exists */
#define	IP_RAWOUTPUT		0x2		/* raw ip header exists */
#define	IP_SENDONES		0x4		/* send all 1s broadcast dst */
#define	IP_ROUTETOIF		SO_DONTROUTE	/* bypass routing tables */
#define	IP_ALLOWBROADCAST	SO_BROADCAST	/* can send broadcast packets */

struct	ipstat	ipstat;
TAILQ_HEAD(ipqhead, ipq) ipq;		/* ip reass. queue */
u_short	ip_id;				/* ip packet ctr, for ids */
int	ip_defttl;			/* default IP ttl */
int	ipforwarding;			/* act as router? */
int	ipforward_srcrt;		/* forward src-routed? */
int	ipsendredirects;		/* send IP redirects when forwarding? */
int	ip_maxfragpackets;		/* Maximum packets in reassembly queue */
int	ip_sourcecheck;			/* Verify source interface */
int	ip_sourcecheck_interval;	/* Interval between log messages */
int	ip_do_rfc1858;			/* use rfc 1858 filtering */

int	 ip_ctloutput __P((int, struct socket *, int, int, struct mbuf **));
int	 ip_dooptions __P((struct mbuf *, int));
void	 ip_drain __P((void));
void	 ip_forward __P((struct mbuf *, int, int));
void	 ip_freemoptions __P((struct ip_moptions *));
int	 ip_getmoptions __P((int, struct ip_moptions *, struct mbuf **));
void	 ip_init __P((void));
int	 ip_mforward __P((struct ip *, struct ifnet *, struct mbuf *));
int	 ip_optcopy __P((struct ip *, struct ip *));
int	 ip_output __P((struct mbuf *, struct mbuf *,
	    struct route *, int, struct ip_moptions *));
int	 ip_pcbopts __P((struct mbuf **, struct mbuf *));
struct in_ifaddr *
	 ip_rtaddr __P((struct in_addr, struct route *));
int	 ip_setmoptions __P((int, struct ip_moptions **, struct mbuf *));
void	 ip_slowtimo __P((void));
struct mbuf *
	 ip_srcroute __P((void));
void	 ip_stripoptions __P((struct mbuf *, struct mbuf *));
int	 ip_sysctl __P((int *, u_int, void *, size_t *, void *, size_t));
int	 ip_ifsysctl __P((struct ifnet *, int *, u_int, void *, size_t *,
	    void *, size_t));
int	 ip_msysctl __P((int *, u_int, void *, size_t *, void *, size_t));
void	 ipintr __P((void));
int	 rip_ctloutput __P((int, struct socket *, int, int, struct mbuf **));
void	 rip_init __P((void));
void	 rip_input __P((struct mbuf *, int, int));
void	 rip_ctlinput __P((int, struct sockaddr *, void *));
int	 rip_output __P((struct mbuf *, struct socket *, u_int32_t));
int	 rip_usrreq __P((struct socket *,
	    int, struct mbuf *, struct mbuf *, struct mbuf *));
#endif

#endif /* !_NETINET_IP_VAR_H_ */
