/*-
 * Copyright (c) 1999 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI ipfw_cache.h,v 1.1 2000/01/21 20:38:45 prb Exp
 */

/*
 * This structure is passed in/out of the kernel to describe a cirucit cache.
 * The length field is ignored when read in by the kernel.
 */
typedef struct {
	u_int		ac_size;	/* number of buckets in circuit */
	u_int		ac_entries;	/* number of entries in the cache */
} ip_cache_hdr_t;

/*
 * Once of these per circuit, try to keep as small as possible.
 */
typedef struct ip_cache {
#ifdef	KERNEL
	struct	ip_cache *ac_next;	/* Next entry in bucket */
	struct	ip_cache *ac_prev;	/* Previous entry in bucket */
#else
	void		*ac_private[2];
#endif
	u_long		ac_hash;
	struct in_addr	ac_a;
} ip_cache_t;

#define IPFWAC_HASH_SIZE	997

#define	IPFWAC_SRC	IPFWF_FILTER1
#define	IPFWAC_DST	0

#define	IPFWAC_BUCKETS	1
#define	IPFWAC_ADD	2
#define	IPFWAC_DELETE	3
