/*-
 * Copyright (c) 1999 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI ipfw_throttle.h,v 1.1 2000/01/19 20:19:40 prb Exp
 */

/*
 * This structure is passed in/out of the kernel to describe a cirucit cache.
 * The length field is ignored when read in by the kernel.
 */
typedef struct {
	u_int		th_size;	/* number of buckets in circuit */
	u_int		th_entries;	/* number of entries in the cache */
	u_int		th_maxentries;	/* maximum flows allowed */
	u_int32_t	th_mask;
	int		th_limit;
	int		th_seconds;
	int		th_flags;
} ip_throttle_hdr_t;

/*
 * Once of these per circuit, try to keep as small as possible.
 */
typedef struct ip_throttle {
#ifdef	KERNEL
	struct	ip_throttle *th_next;	/* Next entry in bucket */
	struct	ip_throttle *th_prev;	/* Previous entry in bucket */
	struct	ip_throttle *th_older;	/* Next entry older than us */
	struct	ip_throttle *th_newer;	/* Next entry younger than us */
	struct	ip_throttle_head	*th_head;
#else
	void		*th_private[5];
#endif
	u_long		th_hash;
	u_long		th_when;	/* last time we were looked at */
	u_int32_t	th_ports;	/* Ports used in this throttle */
	struct in_addr	th_a[2];
	quad_t		th_accepted;
	quad_t		th_denied;
	int		th_weight;
} ip_throttle_t;

#define THROTTLE_HASH_SIZE       997

#define	TH_CHKSRCA	0x01		/* Check source address */
#define	TH_CHKDSTA	0x02		/* Check destination address */

#define	IPFWTHROTTLE_CLOCK	1
#define	IPFWTHROTTLE_BUCKETS	2
