/*	BSDI ipv6.h,v 1.3 2000/05/02 15:09:04 dab Exp	*/
/*
 * This file provides (some) backwards compatability
 * with BSD/OS 4.x, which used the NRL IPv6/IPSec code.
 */

#ifndef NRL_COMPAT
#error "You must define NRL_COMPAT to include <netinet6/ipv6.h>"
#endif /* NRL_COMPAT */

#ifndef _NETINET6_IPV6_H
#define _NETINET6_IPV6_H 1

#include <netinet/ip6.h>


#define IPV6VERSION 6

struct ipv6
{
	u_int32_t ipv6_versfl;
	u_int16_t ipv6_length;
	u_int8_t ipv6_nexthdr;
	u_int8_t ipv6_hoplimit;
	struct in6_addr ipv6_src;
	struct in6_addr ipv6_dst;
};

#include <machine/endian.h>
struct ipv6hdr {
#if BYTE_ORDER == LITTLE_ENDIAN
	u_int8_t ipv6_priority:4;	/* going away? */
	u_int8_t ipv6_version:4;
	u_int32_t ipv6_flowid:24;
#elif BYTE_ORDER == BIG_ENDIAN
	u_int32_t ipv6_flowid:24;
	u_int8_t ipv6_priority:4;	/* going away? */
	u_int8_t ipv6_version:4;
#else
#error "Please fix <machine/endian.h>"
#endif
	u_int16_t ipv6_len;
	u_int8_t ipv6_nextheader;
	u_int8_t ipv6_hoplimit;
	struct in6_addr ipv6_src;
	struct in6_addr ipv6_dst;
};

#undef IPV6_VERSION
#define IPV6_VERSION(h)		((h)->ipv6_versfl >> 28)
#define IPV6_PRIORITY(h)	(((h)->ipv6_versfl & 0x0f000000) >> 24)
#define IPV6_FLOWID(h)		((h)->ipv6_versfl & 0x00ffffff)

#define MAXHOPLIMIT		IPV6_DEFHLIM
#define IPV6_MINMTU		IPV6_MMTU

/* struct ipv6_fraghdr */
#define ipv6_fraghdr	ip6_frag
#define	frag_nexthdr		ip6f_nxt
#define	frag_reserved		ip6f_reserved
#define	frag_bitsoffset		ip6f_offlg
#define	frag_id			ip6f_ident

#define FRAG_MOREMASK		IP6F_MORE_FRAG
#define FRAG_OFFMASK		IP6F_OFF_MASK
#define FRAG_MORE_BIT(fh)	((fh)->frag_bitsoffset & FRAG_MOREMASK)
#define FRAG_OFFSET(fh)		((fh)->frag_bitsoffset & FRAG_OFFMASK)

struct ipv6_srcroute0
{
	u_int8_t i6sr_nexthdr;
	u_int8_t i6sr_len;
	u_int8_t i6sr_type;
	u_int8_t i6sr_left;
	u_int8_t i6sr_reserved;
	u_int8_t i6sr_mask[3];
};

#define I6SR_BITMASK(i6sr)	((i6sr)->i6sr_reserved & 0xffffff)

struct ipv6_opthdr
{
	u_int8_t oh_nexthdr;
	u_int8_t oh_extlen;
	u_int8_t oh_data[6];
};

#define OPT_PAD1	IP6OPT_PAD1
#define OPT_PADN	IP6OPT_PADN
#define OPT_JUMBO	IP6OPT_JUMBO

struct ipv6_option
{
	u_int8_t opt_type;
	u_int8_t opt_datalen;
	u_int8_t opt_data[1];
};

#endif /* _NETINET6_IPV6_H */
