/*	BSDI ipv6_icmp.h,v 1.6 2000/05/04 03:33:23 dab Exp	/
/*
 * This file provides (some) backwards compatability
 * with BSD/OS 4.1, which used the NRL IPv6/IPSec code.
 */
 
#ifndef NRL_COMPAT
#error "You must define NRL_COMPAT to include <netinet6/ipv6_icmp.h>"
#endif /* NRL_COMPAT */

#ifndef _NETINET6_IPV6_ICMP_H
#define _NETINET6_IPV6_ICMP_H 1

#include <netinet/in.h>
#include <netinet/icmp6.h>

struct ipv6_icmp {
	u_int8_t icmp_type;
	u_int8_t icmp_code;
	u_int16_t icmp_cksum;
	union {
		u_int32_t	hun_data32[1];
		u_int16_t	hun_data16[2];
		u_int8_t	hun_data8[4];
	} icmp_hun;
#define	icmp_unused			icmp_hun.hun_data32[0]
#define	icmp_nexthopmtu			icmp_hun.hun_data32[0]
#define	icmp_paramptr			icmp_hun.hun_data32[0]
#define	icmp_echoid			icmp_hun.hun_data16[0]
#define	icmp_echoseq			icmp_hun.hun_data16[1]
#define	icmp_grpdelay			icmp_hun.hun_data16[0]
#define	icmp_grpunused			icmp_hun.hun_data16[1]
#define	icmp_nadvbits			icmp_hun.hun_data32[0]
#define	icmp_radvhop			icmp_hun.hun_data8[0]
#define	icmp_radvbits			icmp_hun.hun_data8[1]
#define	icmp_radvlifetime		icmp_hun.hun_data16[1]
	union {
		struct in6_addr	dun_addr[2];
		u_int32_t	dun_data32[2];
		u_int16_t	dun_data16[2];
		u_int8_t	dun_data8[4][8];
	} icmp_dun;
#define	icmp_ipv6			icmp_dun.dun_addr[0]
#define	icmp_echodata			icmp_dun.dun_data8[0]
#define	icmp_grpaddr			icmp_dun.dun_addr[0]
#define	icmp_radvreach			icmp_dun.dun_data32[0]
#define	icmp_radvretrans		icmp_dun.dun_data32[1]
#define	icmp_radvext			icmp_dun.dun_data8[1]
#define	icmp_nsoltarg			icmp_dun.dun_addr[0]
#define	icmp_nsolext			icmp_dun.dun_data8[2]
#define	icmp_nadvaddr			icmp_dun.dun_addr[0]
#define	icmp_nadvext			icmp_dun.dun_data8[2]
#define	icmp_redirtarg			icmp_dun.dun_addr[0]
#define	icmp_redirdest			icmp_dun.dun_addr[1]
#define	icmp_redirext			icmp_dun.data8[4]
};

#define	EXT_SOURCELINK	ND_OPT_SOURCE_LINKADDR
#define	EXT_TARGETLINK	ND_OPT_TARGET_LINKADDR
#define	EXT_PREFIX	ND_OPT_PREFIX_INFORMATION
#define	EXT_REDIR	ND_OPT_REDIRECTED_HEADER
#define	EXT_MTU		ND_OPT_MTU

struct icmp_exthdr {
	u_int8_t ext_id;
	u_int8_t ext_length;
	u_int8_t ext_data[6];
};

/* struct ext_prefinfo */
#define ext_prefinfo 			nd_opt_prefix_info
#define	    pre_extid			nd_opt_pi_type
#define     pre_length			nd_opt_pi_len
#define	    pre_prefixsize		nd_opt_pi_prefix_len
#define	    pre_bits			nd_opt_pi_flags_reserved
#define	    pre_valid			nd_opt_pi_valid_time
#define	    pre_preferred		nd_opt_pi_preferred_time
#define	    pre_reserved		nd_opt_pi_reserved2
#define	    pre_prefix			nd_opt_pi_prefix

#define ICMPV6_PREFIX_ONLINK		ND_OPT_PI_FLAG_ONLINK
#define ICMPV6_PREFIX_AUTO		ND_OPT_PI_FLAG_AUTO

struct ext_redir {
	u_int8_t rd_extid;
	u_int8_t rd_length;
	u_int8_t rd_reserved[6];
	struct ipv6 rd_header;
};

/* struct ext_mtu */
#define	ext_mtu				nd_opt_mtu
#define	    mtu_extid			nd_opt_mtu_type
#define	    mtu_length			nd_opt_mtu_len
#define	    mtu_reserved		nd_opt_mtu_reserved
#define	    mtu_mtu			nd_opt_mtu_mtu

#define	ICMPV6_MINLEN			sizeof(struct icmp6_hdr)
#define	ICMPV6_TSLEN			(8 + 3 * sizeof (n_time))
#define	ICMPV6_NADVMINLEN		sizeof(struct nd_neighbor_advert)
#define ICMPV6_NSOLMINLEN		sizeof(struct nd_neighbor_solicit)
#define ICMPV6_RADVMINLEN		sizeof(struct nd_router_advert)
#define ICMPV6_RSOLMINLEN		sizeof(struct nd_router_solicit)
#define ICMPV6_REDIRMINLEN		sizeof(struct nd_redirect)
#define ICMPV6_HLPMINLEN		(8+sizeof(struct ipv6)+8)
#define ICMPV6_MAXLEN			IPV6_MMTU

#define	ICMPV6_UNREACH			ICMP6_DST_UNREACH
#define	    ICMPV6_UNREACH_NOROUTE	ICMP6_DST_UNREACH_NOROUTE
#define	    ICMPV6_UNREACH_ADMIN	ICMP6_DST_UNREACH_ADMIN
#define	    ICMPV6_UNREACH_NOTNEIGHBOR	ICMP6_DST_UNREACH_NOTNEIGHBOR
#define	    ICMPV6_UNREACH_ADDRESS	ICMP6_DST_UNREACH_ADDR
#define	    ICMPV6_UNREACH_PORT		ICMP6_DST_UNREACH_NOPORT
#define	ICMPV6_TOOBIG			ICMP6_PACKET_TOO_BIG
#define	ICMPV6_TIMXCEED			ICMP6_TIME_EXCEEDED
#define	    ICMPV6_TIMXCEED_INTRANS	ICMP6_TIME_EXCEED_TRANSIT
#define	    ICMPV6_TIMXCEED_REASS	ICMP6_TIME_EXCEED_REASSEMBLY
#define	ICMPV6_PARAMPROB		ICMP6_PARAM_PROB
#define	    ICMPV6_PARAMPROB_PROB	ICMP6_PARAMPROB_HEADER
#define	    ICMPV6_PARAMPROB_NEXTHDR	ICMP6_PARAMPROB_NEXTHEADER
#define	    ICMPV6_PARAMPROB_BADOPT	ICMP6_PARAMPROB_OPTION
#define	ICMPV6_ECHO			ICMP6_ECHO_REQUEST
#define	ICMPV6_ECHOREPLY		ICMP6_ECHO_REPLY
#define ICMPV6_GRPQUERY			ICMP6_MEMBERSHIP_QUERY
#define ICMPV6_GRPREPORT		ICMP6_MEMBERSHIP_REPORT
#define ICMPV6_GRPTERM			ICMP6_MEMBERSHIP_REDUCTION
#define	ICMPV6_ROUTERSOL		ND_ROUTER_SOLICIT
#define	ICMPV6_ROUTERADV		ND_ROUTER_ADVERT
#define	ICMPV6_NEIGHBORSOL		ND_NEIGHBOR_SOLICIT
#define	ICMPV6_NEIGHBORADV		ND_NEIGHBOR_ADVERT
#define ICMPV6_REDIRECT			ND_REDIRECT
#define	ICMPV6_NEIGHBORADV_RTR		ND_NA_FLAG_ROUTER
#define	ICMPV6_NEIGHBORADV_SOL		ND_NA_FLAG_SOLICITED
#define	ICMPV6_NEIGHBORADV_OVERRIDE	ND_NA_FLAG_OVERRIDE
#define	ICMPV6_MAXTYPE			ICMP6_MAXTYPE
#define	ICMPV6_INFOTYPE(type)		((type) & ICMP6_INFOMSG_MASK)

#endif /* _NETINET6_IPV6_ICMP_H */
