/*-
 * Copyright (c) 1998 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *      BSDI nlminfo.h,v 2.2 2001/02/16 21:05:20 jch Exp
 */


/* 
 *
 *      These data structures support cleaning up file locks whenever lockd
 *      exits (SEGV or killed) and whenever lockd is notified a client has
 *      rebooted, and also makes it easier to manage vnode reference
 *      counts and specify the identity of lockers.
 *
 *      The nfsowner table is logically an array of pointers to linked
 *      lists of objects (struct vid) containing a vnode pointer.
 *      An additional layer is inserted so the table can grow, as
 *      we can realloc the top level as required (just like the
 *      per-process file descriptor table).  The bottom layer cannot
 *      move, since their indicies are used as the nfs owner
 *      identity.
 *
 *	Available entries are kept on a free list using entry indexes
 *	instead of pointers.  This avoids future problems with 64-bit
 *	pointers and allows us to quickly find an unused entry.
 *
 *      The filesystem specific VOP_ADVLOCK() routine manages the vid list.
 *      For every vnode which that filesystem has a lock on (for VOP_ADVLOCK
 *      called with the flag F_ONLIST), at least one vid node should be on
 *      the vid list, and the vnode's reference count should number the
 *      number of references by the various vid nodes on the vid list.
 *
 *      This structure is also allocated for any client requesting a lock
 *      on an nfs file, but only the retcode field is actually used.
 *
 */

typedef struct nfsowner_ent {
	union {
		struct vidhead u_vh;
		int u_next;
	} nfso_u;
} nfsowner_ent;
#define	nfso_vh	nfso_u.u_vh
#define	nfso_next nfso_u.u_next

/*
 * Misc NLM informationi, some needed for the master lockd process, and some
 * needed by every process doing nlm based locking.
 */
struct  nlminfo {
	/* these are used by the master lockd process */
        nfsowner_ent    **owners;       /* 2 level expandable array */
	int		free_list;	/* Index of first free entry */
        int             max_index;      /* bound on allocated 2nd level array */
        int             tbl_cnt;        /* # of pointers to 2nd level */
	/* these are used by any process doing nlm locking */
        int             msg_seq;        /* sequence counter for lock requests */
        int             retcode;        /* return code for lock requests */
	int		set_getlk_pid;
	int		getlk_pid;
        struct  timeval pid_start;      /* process starting time */
};

extern void nlminfo_release __P((struct proc *p));

