/*	BSDI stdarg.h,v 2.3 1998/01/14 19:02:01 donn Exp	*/

/*-
 * Copyright (c) 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)stdarg.h	8.1 (Berkeley) 6/10/93
 */

#ifndef _MACHINE_STDARG_H_
#define	_MACHINE_STDARG_H_

typedef char *va_list;

#ifndef __GNUC__

#define	__va_promote(type) \
	(((sizeof(type) + sizeof(int) - 1) / sizeof(int)) * sizeof(int))

#define	va_start(ap, last) \
	(ap = ((char *)&(last) + __va_promote(last)))

#define	va_arg(ap, type) \
	((type *)(ap += sizeof(type)))[-1]

#else

/*
 * The following fancy version uses GNU extensions to save
 * users from disaster when they write code like va_arg(ap, short).
 * It sure would be nice if we could issue a warning as well...
 */

#if __GNUC__ < 2 && !defined(__extension__)
#define	__extension__
#endif

#ifdef _VARARGS_H_
#define	va_start(ap)	(ap = (va_list)__builtin_frame_address(0))
#define	va_alist	__va_dummy
#define	va_dcl		int __va_dummy; ...
#else
#define	va_start(ap, x)	(ap = (va_list)((long *)&(x) + __va_words(__typeof(x))))
#endif

/* Interface from GNU typeclass.h */
enum __va_type_classes {
	__no_type_class = -1, __void_type_class, __integer_type_class,
	__char_type_class, __enumeral_type_class, __boolean_type_class,
	__pointer_type_class, __reference_type_class, __offset_type_class,
	__real_type_class, __complex_type_class, __function_type_class,
	__method_type_class, __record_type_class, __union_type_class,
	__array_type_class, __string_type_class, __set_type_class,
	__file_type_class, __lang_type_class
};

#define	__va_words(t)	__extension__ ( \
	__builtin_classify_type(*(t *)0) == __real_type_class ? \
	    sizeof (*(t *)0) > sizeof (double) ? 4 : 2 : \
	__builtin_classify_type(*(t *)0) == __record_type_class || \
	__builtin_classify_type(*(t *)0) == __union_type_class ? \
	    (sizeof (*(t *)0) + sizeof (int) - 1) / sizeof (int) : \
	__builtin_classify_type(*(t *)0) == __integer_type_class && \
	    sizeof (*(t *)0) > sizeof (int) ? 2 : 1 \
)

/*
 * __va_rtype(t) generates the 'rvalue' type of type t.
 * If t is an array type, then __va_rtype(t) is a pointer type.
 */
#define	__va_rtype(t)	__typeof(((void)0, *(t *)0))

#define	va_arg(ap, t)	__extension__ ({ \
	va_list __va_tmp = ap; \
	float __va_float; \
\
	ap = (va_list)((long *)ap + __va_words(__va_rtype(t))); \
	if (__builtin_classify_type(*(t *)0) == __real_type_class && \
	    sizeof (*(t *)0) == sizeof (float)) { \
		/* floats don't nest inside doubles... */ \
		__va_float = *(double *)__va_tmp; \
		__va_tmp = (va_list)&__va_float; \
	} \
	*(__va_rtype(t) *)__va_tmp; \
})

#endif	/* __GNUC__ */

#define	va_end(ap)

#endif	/* _MACHINE_STDARG_H_ */
