/*
 * Copyright (c) 1997, 4Front Technologies. All rights reserved
 * Header definitions for the Open Sound System - Direct Music API
 */

#ifndef _H_SB
#define _H_SB

#ifdef PRO
#include "../soundcard.h"
#else
#include <sys/soundcard.h>
#endif

/* PCM and ADPCM (compression) definitions */
#define PCM_8			0x01
#define ADPCM_2			0x02
#define ADPCM_3			0x03
#define ADPCM_4			0x04

/* Device Names */
#define DMDSP	"/dev/dmdsp0"
#define DMFM    "/dev/dmfm0"
#define DMMIDI  "/dev/dmmidi0"

/* FM IOCTLS */
#define FM_IOCTL_RESET        0x20
#define FM_IOCTL_PLAY_NOTE    0x21
#define FM_IOCTL_SET_VOICE    0x22
#define FM_IOCTL_SET_PARAMS   0x23
#define FM_IOCTL_SET_MODE     0x24
#define FM_IOCTL_SET_OPL      0x25

#define OPL2		0
#define OPL3		1

/*
 * Data structure composing an FM "note" or sound event.
 */
struct dm_fm_voice
{
  unsigned char op;               	/* Operator cell (0 or 1) */
  unsigned char voice;                  /* FM voice (0 to 17) */

  unsigned char am;                     /* Amplitude modulation */
  unsigned char vibrato;                /* Vibrato effect */
  unsigned char do_sustain;             /* Sustain phase */
  unsigned char kbd_scale;              /* Keyboard scaling */
  unsigned char harmonic;               /* 4 bits: Harmonic or multiplier */
  unsigned char scale_level;            /* 2 bits: Decrease output  freq rises*/
  unsigned char volume;                 /* 6 bits: Volume */

  unsigned char attack;                 /* 4 bits: Attack rate */
  unsigned char decay;                  /* 4 bits: Decay rate */
  unsigned char sustain;                /* 4 bits: Sustain level  */
  unsigned char release;                /* 4 bits: Release rate */

  unsigned char feedback;               /* 3 bits: Feedback for op0 */
  unsigned char connection;             /* 0 for serial, 1 for parallel*/
  unsigned char left;                   /* Stereo Right */
  unsigned char right;                  /* Stereo Right */
  unsigned char waveform;               /* 3 bits: Waveform shape */
};

struct dm_fm_note
{
  unsigned char voice;			/* 0-17 voice channel */
  unsigned char octave;                 /* 3 bits: What octave to play*/
  unsigned int fnum;                    /* 10 bits: Frequency "number" */
  unsigned char key_on;                 /* Set for active, Clear for silent */
};

/*
 * FM parameters that apply globally to all voices, and thus are not "notes"
 */
struct dm_fm_params
{
  unsigned char am_depth;                /* Amplitude Modulation depth (1=hi) */
  unsigned char vib_depth;               /* Vibrato depth (1=hi) */
  unsigned char kbd_split;               /* Keyboard split */
  unsigned char rhythm;                  /* Percussion mode select */

  /* Percussion instruments */
  unsigned char bass;
  unsigned char snare;
  unsigned char tomtom;
  unsigned char cymbal;
  unsigned char hihat;
};

#endif /* _H_SB */

