/*-
 * Copyright (c) 2000 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 * BSDI entropy.h,v 1.1.2.1 2001/05/03 18:20:19 prb Exp
 */

#ifndef _SYS_ENTROPY_H_
#define _SYS_ENTROPY_H_

/*
 * Various locations that we might collect entropy from.
 * The collect_entropy routine should only collect entropy
 * for known types and just return for unknown types.
 */
typedef enum {
	ENTROPY_HARDCLOCK,
	ENTROPY_MISC
} entropy_t;

/*
 * When getting entropy (randomness) we pass in flags saying what
 * we can accept
 */
#define	ENTROPY_NOWAIT	0x0000		/* Do not wait for entorpy */
#define	ENTROPY_WAIT	0x0001		/* Wait for entorpy to be produced */
#define	ENTROPY_PSEUDO	0x0002		/* Generate pseudo entropy if needed */

u_int32_t get_entropy32(int);
u_int64_t get_entropy64(int);
#endif
