/*	BSDI mtio.h,v 2.6 1997/08/26 17:03:13 cp Exp	*/

/*
 * Copyright (c) 1982, 1986, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)mtio.h	8.1 (Berkeley) 6/2/93
 */

#ifndef _SYS_MTIO_H_
#define _SYS_MTIO_H_

/*
 * Structures and definitions for mag tape io control commands
 */

/* structure for MTIOCTOP - mag tape op command */
struct mtop {
	short	mt_op;		/* operations defined below */
	daddr_t	mt_count;	/* how many of them */
};

/* operations */
#define MTWEOF		0	/* write an end-of-file record */
#define MTFSF		1	/* forward space file */
#define MTBSF		2	/* backward space file */
#define MTFSR		3	/* forward space record */
#define MTBSR		4	/* backward space record */
#define MTREW		5	/* rewind */
#define MTOFFL		6	/* rewind and put the drive offline */
#define MTNOP		7	/* no operation, sets status only */
#define MTCACHE		8	/* enable controller cache */
#define MTNOCACHE	9	/* disable controller cache */
#define MTLOAD		10	/* load media */
#define MTRETENSION	11	/* retension media */

/* structure for MTIOCGET - mag tape get status command */

struct mtget {
	short	mt_type;	/* type of magtape device */
/* the following two registers are grossly device dependent */
	short	mt_dsreg;	/* ``drive status'' register */
	short	mt_erreg;	/* ``error'' register */
/* end device-dependent registers */
	short	mt_resid;	/* residual count */
/* the following two are not yet implemented */
	daddr_t	mt_fileno;	/* file number of current position */
	daddr_t	mt_blkno;	/* block number of current position */
/* end not yet implemented */
};

/*
 * Constants for mt_type byte.  These are the same
 * for controllers compatible with the types listed.
 */
#define	MT_ISTS		0x01		/* TS-11 */
#define	MT_ISHT		0x02		/* TM03 Massbus: TE16, TU45, TU77 */
#define	MT_ISTM		0x03		/* TM11/TE10 Unibus */
#define	MT_ISMT		0x04		/* TM78/TU78 Massbus */
#define	MT_ISUT		0x05		/* SI TU-45 emulation on Unibus */
#define	MT_ISCPC	0x06		/* SUN */
#define	MT_ISAR		0x07		/* SUN */
#define	MT_ISTMSCP	0x08		/* DEC TMSCP protocol (TU81, TK50) */
#define MT_ISCY		0x09		/* CCI Cipher */
#define MT_ISCT		0x0a		/* HP 1/4 tape */
#define MT_ISFHP	0x0b		/* HP 7980 1/2 tape */
#define MT_ISEXABYTE	0x0c		/* Exabyte */
#define MT_ISEXA8200	0x0c		/* Exabyte EXB-8200 */
#define MT_ISEXA8500	0x0d		/* Exabyte EXB-8500 */
#define MT_ISVIPER1	0x0e		/* Archive Viper-150 */
#define MT_ISPYTHON	0x0f		/* Archive Python (DAT) */
#define MT_ISHPDAT	0x10		/* HP 35450A DAT drive */
#define MT_ISMFOUR	0x11		/* M4 Data 1/2 9track drive */
#define MT_ISTK50	0x12		/* DEC SCSI TK50 */
#define MT_ISMT02	0x13		/* Emulex MT02 SCSI tape controller */


struct mt_name {
	char	mn_vendor[100];
	char	mn_product[100];
	char	mn_revision[100];
};

struct mt_position {
	u_int	mp_flags;
#define MT_PARTITION_VALID		0x01
#define MT_PARTITION_APPLICABLE		0x02
#define MT_FILE_VALID			0x04
#define MT_FILE_APPLICABLE		0x08
#define MT_BLOCK_VALID			0x10
#define MT_BLOCK_APPLICABLE		0x20
	u_int	mp_partition;
	u_int	mp_file;
	u_int	mp_block;
};


/*
 * The same bit definitions are used with all fields in mt_status.
 * The ms_status bits indicates the state associated with a given bit.
 * The ms_valid bits indicated the driver believes it knows the 
 *  state associated with a given bit. An error can cause the driver to
 *  loose state in which case the associated bit in ms_valid
 *  would be returned zero.
 * The ms_applicable is used to indicated if a given bit has any
 *  meaning at all to the driver.
 */
struct mt_status {
	u_int	ms_status;
	u_int	ms_valid;
	u_int	ms_applicable;
};
#define MT_REWINDING	0x01	/* Drive is rewinding */
#define MT_BOT		0x02	/* Begining of tape */
#define MT_EOD		0x04	/* End of data */
#define MT_EOM		0x08	/* End of Medium */
#define MT_MUSTREWIND	0x10
#define MT_DEAD		0x20
#define MT_RONLY	0x40
#define MT_NOMEDIA	0x80


/* mag tape io control commands */
#define	MTIOCTOP	_IOW('m', 1, struct mtop)	/* do a mag tape op */
#define	MTIOCGET	_IOR('m', 2, struct mtget)	/* get tape status */
#define MTIOCIEOT	_IO('m', 3)			/* ignore EOT error */
#define MTIOCEEOT	_IO('m', 4)			/* enable EOT error */
#define MTIOCSFBS	_IOW('m', 5, int)	/* set fixed block size */
#define MTIOCGFBS	_IOR('m', 6, int)	/* get fixed block size */
#define MTIOGNAME	_IOR('m', 7, struct mt_name)
#define MTIOGSTATUS	_IOR('m', 8, struct mt_status)
/*
 * Get position from controller/driver. Don't talk to the target 
 * The idea is that there will be another ioctl for getting the position
 * from the target.
 */
#define MTIOCGPOSITION	_IOR('m', 9, struct mt_position)
					

#ifndef KERNEL
#define	DEFTAPE	"/dev/nrst0"
#endif

#ifdef	KERNEL
/*
 * Minor device subunit encoding.
 * We have 10 bits: the low bit is no-rewind, and the others are used
 * for density and/or other device-dependent treatment such as fixed
 * vs. variable records.  The three traditional density names are sometimes
 * redefined by the driver.  Note that density code 0 is now reserved
 * for either the default or the "current" density.  For the convenience
 * of drivers that want some density bits plus one additional flag,
 * we exclude the high bit of the subunit from the T_DENSEL mask,
 * and define T_FIXED as an example flag.
 */

#define	T_NOREWIND	0x001		/* no rewind on close */
#define	T_DENSEL	0x1fe		/* density select/other treatment */
#define	T_DFLDEN	0x000		/* default density */
#define	T_800BPI	0x002		/* select  800 bpi */
#define	T_1600BPI	0x004		/* select 1600 bpi */
#define	T_6250BPI	0x006		/* select 6250 bpi */
#define	T_BADBPI	0x008		/* undefined selection */
#define	T_FIXED		0x200		/* fixed-size records */
#endif

#endif /* !_SYS_MTIO_H_ */
