/*	BSDI param.h,v 2.15.6.3 2001/05/09 21:12:09 polk Exp	*/

/*-
 * Copyright (c) 1982, 1986, 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)param.h	8.3 (Berkeley) 4/4/95
 */

#ifndef _SYS_PARAM_H_
#define _SYS_PARAM_H_

#define	BSD	199506		/* Berkeley system version (year & month). */
#define BSD4_3	1
#define BSD4_4	1

#define	_BSDI_VERSION	200105	/* May, 2001 version of BSDI system */

#ifndef NULL
#define	NULL	0
#endif

#ifndef LOCORE
#include <sys/types.h>
#endif

/*
 * Machine-independent constants (some used in following include files).
 * Redefined constants are from POSIX 1003.1 limits file.
 *
 * MAXCOMLEN should be >= sizeof(ac_comm) (see <acct.h>)
 * MAXLOGNAME should be >= UT_NAMESIZE (see <utmp.h>)
 */
#include <sys/syslimits.h>

#define	MAXCOMLEN	16		/* max command name remembered */
#define	MAXINTERP	32		/* max interpreter file name length */
#define	MAXLOGNAME	16		/* max login name length */
#define	MAXUPRC		CHILD_MAX	/* max simultaneous processes */
#define	NCARGS		ARG_MAX		/* max bytes for an exec function */
#define	NGROUPS		NGROUPS_MAX	/* max number groups */
#define	NOFILE		OPEN_MAX	/* max open files per process */
#define	NOGROUP		65535		/* marker for empty group set member */
#define MAXHOSTNAMELEN	256		/* max hostname size */

/* More types and definitions used throughout the kernel. */
#ifdef KERNEL
#include <machine/compat.h>		/* possibly should be earlier? */
#include <sys/cdefs.h>
#include <sys/errno.h>
#include <sys/time.h>
#include <sys/queue.h>
#include <sys/resource.h>
#include <sys/ucred.h>
#include <sys/uio.h>
#endif

/* Signals. */
#include <sys/signal.h>

/* Machine type dependent parameters. */
/*
 * spl prototypes don't "belong" here, but they may be implemented inline
 * or in macros on some machines, and this is the only file that is always
 * included.  Put the prototypes before inclusion of <machine/param.h>,
 * which may define them as macros.
 */
#ifdef KERNEL
int	spl0 __P((void));
int	splsoftclock __P((void));
int	splnet __P((void));
int	splimp __P((void));
int	splmem __P((void));
int	spltty __P((void));
int	splbio __P((void));
int	splclock __P((void));
int	splstatclock __P((void));
int	splhigh __P((void));
int	splraise __P((int));
void	splx __P((int));
int	splmem_fast __P((void));
void	splxmem_fast __P((int));
#endif
#include <machine/param.h>
#include <machine/limits.h>

/*
 * Priorities.  There are 32 run queues, each of which holds 4 priorities;
 * the queues are sorted by priority.  Perhaps we should switch to 128
 * queues, but we currently use a 32-bit mask to record which queues
 * have contents.
 */
#define	PSWP	0
#define	PVM	4
#define	PINOD	8
#define	PRIBIO	12
#define	PVFS	16
#define	PZERO	18		/* No longer magic, shouldn't be here.  XXX */
#define	PSOCK	20
#define	PWAIT	24
#define	PLOCK	28
#define	PPAUSE	32
#define	PKMAX	35		/* numerical max kernel priority, see PKMASK */
/*
 * User-level priorities run from PUMIN through MAXPRI.  The lower (better)
 * priorities range from PRTMIN through rtmaxpriority (PRTMAX by default).
 * Normal user programs start at userpriority (PUSER by default) and float
 * up and down with CPU usage and time.
 */
#define	PUMIN	36		/* numerical min user priority, see PUMASK */
#define	PRTMIN	36		/* Real-time min (best) prio */
#define	PRTMAX	43		/* Real-time max (worst) prio, default */
#define	PUSER	50		/* Default value for userpriority */
#define	MAXPRI	127		/* Priorities range from 0 through MAXPRI. */

/* priority queue masks that should agree with the above: */
#define PKMASK	0x1ff		/* Which of 32 run queues are kernel */
#define PUMASK	(~PKMASK)	/* Which of 32 run queues are user */
#define PRTMASK_INIT 0x600	/* Which run queues include real-time, dflt */

/* priority parameter for tsleep() */
#define	PRIMASK	0x0ff
#define	PCATCH	0x100		/* OR'd with pri for tsleep to check signals */

#define	NZERO	0		/* default "nice" */

/*
 * kernel priorities decrease in value for an increase in priority. User
 * (POSIX) priorities do the opposite. Therefore a conversion must be made.
 */
/* Convert sys/user priorities */
#define ADJPRIO(prio)	(MAXPRI - prio)

#define	NBPW	sizeof(int)	/* number of bytes per word (integer) */

#define	CMASK	022		/* default file mask: S_IWGRP|S_IWOTH */
#define	NODEV	(dev_t)(-1)	/* non-existent device */

#ifdef KERNEL
#define	RR_INTERVAL	(hz / 10)	/* SCHED_RR interval definition */
#endif

/*
 * Clustering of hardware pages on machines with ridiculously small
 * page sizes is done here.  The paging subsystem deals with units of
 * CLSIZE pte's describing NBPG (from machine/machparam.h) pages each.
 */
#define	CLBYTES		(CLSIZE*NBPG)
#define	CLOFSET		(CLSIZE*NBPG-1)	/* for clusters, like PGOFSET */
#define	claligned(x)	((((int)(x))&CLOFSET)==0)
#define	CLOFF		CLOFSET
#define	CLSHIFT		(PGSHIFT+CLSIZELOG2)

#if CLSIZE==1
#define	clbase(i)	(i)
#define	clrnd(i)	(i)
#else
/* Give the base virtual address (first of CLSIZE). */
#define	clbase(i)	((i) &~ (CLSIZE-1))
/* Round a number of clicks up to a whole cluster. */
#define	clrnd(i)	(((i) + (CLSIZE-1)) &~ (CLSIZE-1))
#endif

/*
 * File system parameters and macros.
 *
 * The file system is made out of blocks of at most MAXBSIZE units, with
 * smaller units (fragments) only in the last direct block.  MAXBSIZE
 * primarily determines the size of buffers in the buffer pool.  It may be
 * made larger without any effect on existing file systems; however making
 * it smaller make make some file systems unmountable.
 */
#define	MAXBSIZE	MAXPHYS
#define MAXFRAG 	8

/*
 * MAXPATHLEN defines the longest permissable path length after expanding
 * symbolic links. It is used to allocate a temporary buffer from the buffer
 * pool in which to do the name expansion, hence should be a power of two,
 * and must be less than or equal to MAXBSIZE.  MAXSYMLINKS defines the
 * maximum number of symbolic links that may be expanded in a path name.
 * It should be set high enough to allow all legitimate uses, but halt
 * infinite loops reasonably quickly.
 */
#define	MAXPATHLEN	PATH_MAX
#define MAXSYMLINKS	20

/* Bit map related macros. */
#define	setbit(a,i)	((a)[(u_int)(i) / NBBY] |= 1 << ((u_int)(i) % NBBY))
#define	clrbit(a,i)	((a)[(u_int)(i) / NBBY] &= ~(1 << ((u_int)(i) % NBBY)))
#define	isset(a,i)	((a)[(u_int)(i) / NBBY] & (1 << ((u_int)(i) % NBBY)))
#define	isclr(a,i)	(((a)[(u_int)(i)/NBBY] & (1 << ((u_int)(i)%NBBY))) == 0)

/* Macros for counting and rounding. */
#ifndef howmany
#define	howmany(x, y)	(((x)+((y)-1))/(y))
#endif
#define	roundup(x, y)	((((x)+((y)-1))/(y))*(y))
#define powerof2(x)	((((x)-1)&(x))==0)

/* Macros for min/max. */
#ifndef KERNEL
#define	MIN(a,b) (((a)<(b))?(a):(b))
#define	MAX(a,b) (((a)>(b))?(a):(b))
#endif

/*
 * Constants for setting the parameters of the kernel memory allocator.
 *
 * 2 ** MINBUCKET is the smallest unit of memory that will be
 * allocated. It must be at least large enough to hold a pointer.
 *
 * Units of memory less or equal to MAXALLOCSAVE will permanently
 * allocate physical memory; requests for these size pieces of
 * memory are quite fast. Allocations greater than MAXALLOCSAVE must
 * always allocate and free physical memory; requests for these
 * size allocations should be done infrequently as they will be slow.
 *
 * Constraints: CLBYTES <= MAXALLOCSAVE <= 2 ** (MINBUCKET + 14), and
 * MAXALLOCSIZE must be a power of two.
 */
#define MINBUCKET	4		/* 4 => min allocation of 16 bytes */
#define MAXALLOCSAVE	(2 * CLBYTES)

/*
 * Maxmapentries is a limit that defends against over-use of
 * VM data structures by a single process.  If a non-root process
 * is using maxmapentries or more vm_map_entry structures, 
 * the system prevents it from using mmap()-related system calls
 * to increase the number of structures that are devoted to it.
 * The main goal is to avoid exhaustion of this common resource
 * by an out-of-control program or a denial-of-service attack.
 * The MAXMAPENTRIES constant is the starting value for maxmapentries,
 * which may be adjusted using sysctl(3).
 */
#define	MAXMAPENTRIES	1024

/*
 * Scale factor for scaled integers used to count %cpu time and load avgs.
 *
 * The number of CPU `tick's that map to a unique `%age' can be expressed
 * by the formula (1 / (2 ^ (FSHIFT - 11))).  The maximum load average that
 * can be calculated (assuming 32 bits) can be closely approximated using
 * the formula (2 ^ (2 * (16 - FSHIFT))) for (FSHIFT < 15).
 *
 * For the scheduler to maintain a 1:1 mapping of CPU `tick' to `%age',
 * FSHIFT must be at least 11; this gives us a maximum load avg of ~1024.
 */
#define	FSHIFT	11		/* bits to right of fixed binary point */
#define FSCALE	(1<<FSHIFT)

#endif /* !_SYS_PARAM_H_ */
