/*-
 * Copyright (c) 1996, 2001 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 * BSDI sched.h,v 1.1.2.1 2001/04/24 00:11:47 peer Exp 
 */

#ifndef	_SYS_SCHED_H_
#define	_SYS_SCHED_H_

#ifndef KERNEL
#include <time.h>
#endif

#define	_POSIX_PRIORITY_SCHEDULING	1	/* almost, at least */

/* policy 0 is unused */
#define	SCHED_FIFO	1	/* Preemptive priority scheduler */
#define	SCHED_RR	2	/* Preemptive priority scheduler w/quantum */
#define	SCHED_OTHER	3	/* default non-realtime scheduler */
#define	SCHED_POLICYMAX	3	/* for bounds checking */

struct sched_param {
	int	sched_priority;	/* priority for priority based schedulers */
};

#ifdef KERNEL

/* Is it Real-time scheduling? */
#define	SCHED_IS_RT(policy)	((policy) == SCHED_RR || \
				   (policy) == SCHED_FIFO) 
/* Is it round-robin scheduling? */
#define	SCHED_IS_RR(policy)	((policy) == SCHED_RR || \
				   (policy) == SCHED_OTHER) 
#define	SCHED_IS_VALID(policy)	((policy) > 0 && (policy) <= SCHED_POLICYMAX)

extern	int	userpriority;
extern	int	rtmaxpriority;

#else


/*
 * Scheduling function prototypes
 */
__BEGIN_DECLS
int	sched_setparam __P((pid_t, const struct sched_param *));
int	sched_getparam __P((pid_t, const struct sched_param *));
int	sched_setscheduler __P((pid_t, int, const struct sched_param *));
int	sched_getscheduler __P((pid_t));
int	sched_yield __P((void));
int	sched_get_priority_max __P((int));
int	sched_get_priority_min __P((int));
int	sched_rr_get_interval __P((int, struct timespec *));
__END_DECLS

#endif /* KERNEL */

#endif /* _SYS_SCHED_H */
