/*-
 * Copyright (c) 1993, 1994, 1995 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI systm.h,v 2.18 2001/03/06 16:22:34 giff Exp
 */


/*-
 * Copyright (c) 1982, 1988, 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)systm.h	8.7 (Berkeley) 3/29/95
 */

#ifndef _SYS_SYSTM_H_
#define _SYS_SYSTM_H_

/*
 * The `securelevel' variable controls the security level of the system.
 * It can only be decreased by process 1 (/sbin/init).
 *
 * Security levels are as follows:
 *   -1	permannently insecure mode - always run system in level 0 mode.
 *    0	insecure mode - immutable and append-only flags make be turned off.
 *	All devices may be read or written subject to permission modes.
 *    1	secure mode - immutable and append-only flags may not be changed;
 *	raw disks of mounted filesystems, /dev/mem, and /dev/kmem are
 *	read-only.
 *    2	highly secure mode - same as (1) plus raw disks are always
 *	read-only whether mounted or not. This level precludes tampering 
 *	with filesystems by unmounting them, but also inhibits running
 *	newfs while the system is secured.
 *
 * In normal operation, the system runs in level 0 mode while single user
 * and in level 1 mode while multiuser. If level 2 mode is desired while
 * running multiuser, it can be set in the multiuser startup script
 * (/etc/rc.local) using sysctl(1). If it is desired to run the system
 * in level 0 mode while multiuser, initialize the variable securelevel
 * in /sys/kern/kern_sysctl.c to -1. Note that it is NOT initialized to
 * zero as that would allow the vmunix binary to be patched to -1.
 * Without initialization, securelevel loads in the BSS area which only
 * comes into existence when the kernel is loaded and hence cannot be
 * patched by a stalking hacker.
 */
extern int securelevel;		/* system security level */
extern const char *panicstr;	/* panic message */
extern char version[];		/* system version */
extern char copyright[];	/* system copyright */

extern int nswdev;		/* number of swap devices */
extern int nswap;		/* size of swap space */

extern int selwait;		/* select timeout address */

extern int maxmem;		/* max memory per process */
extern int physmem;		/* physical memory */

extern dev_t dumpdev;		/* dump device */
extern long dumplo;		/* offset into dumpdev */

extern dev_t rootdev;		/* root device */
extern struct vnode *rootvp;	/* vnode equivalent to above */

extern dev_t swapdev;		/* swapping device */
extern struct vnode *swapdev_vp;/* vnode equivalent to above */

extern struct sysent {		/* system call table */
	short	sy_narg;	/* number of args */
	short	sy_argsize;	/* total size of arguments */
	int	(*sy_call)();	/* implementing function */
} sysent[];
extern int nsysent;
#define	SCARG(p,k)	((p)->k.datum)	/* get arg from args pointer */

extern int boothowto;		/* reboot flags, from console subsystem */
extern int numcpu;		/* Number of CPUs running */

typedef	void (*prf_t) __P((const char *fmt, ...));

/* casts to keep lint happy */
#define	insque(q,p)	_insque((caddr_t)q,(caddr_t)p)
#define	remque(q)	_remque((caddr_t)q)

/*
 * General function declarations.
 */
int	nullop __P((void));
int	enodev __P((void));
int	enoioctl __P((void));
int	enxio __P((void));
int	eopnotsupp __P((void));
int	einval __P((void));
int	seltrue __P((dev_t dev, int which, struct proc *p));
void	*hashinit __P((int count, int type, u_long *hashmask));
int	nosys __P((struct proc *, void *, register_t *));

__dead void	panic __P((const char *, ...)) __attribute__((volatile));
void	addlog __P((const char *, ...));
void	aprint_debug __P((const char *, ...));
void	aprint_naive __P((const char *, ...));
void	aprint_normal __P((const char *, ...));
void	aprint_verbose __P((const char *, ...));
void	log __P((int, const char *, ...));
void	printf __P((const char *, ...));
int	sprintf __P((char *buf, const char *, ...));
int	snprintf __P((char *buf, size_t, const char *, ...));
void	tablefull __P((const char *));
void	ttyprintf __P((struct tty *, const char *, ...));
void	uprintf __P((const char *, ...));

void	bcopy __P((const void *from, void *to, size_t len));
void	ovbcopy __P((const void *from, void *to, size_t len));
void	bzero __P((void *buf, size_t len));

int	copystr __P((const void *kfaddr, void *kdaddr, u_int len, u_int *done));
int	copyinstr __P((const void *uaddr, void *kaddr, u_int len, u_int *done));
int	copyoutstr __P((const void *kaddr, void *uaddr, u_int len, u_int *done));
int	copyin __P((const void *uaddr, void *kaddr, u_int len));
int	copyout __P((const void *kaddr, void *uaddr, u_int len));

int	fubyte __P((const void *base));
int	fuibyte __P((const void *base));
int	subyte __P((void *base, int byte));
int	suibyte __P((void *base, int byte));
int	fuword __P((const void *base));
int	fuiword __P((const void *base));
int	suword __P((void *base, int word));
int	suiword __P((void *base, int word));

struct uio;
int	uiomove __P((void *, int, struct uio *));
int	ureadc __P((int, struct uio *));
int	uwritec __P((struct uio *));

int	hzto __P((struct timeval *tv));
void	timeout __P((void (*func)(void *), void *arg, int ticks));
void	untimeout __P((void (*func)(void *), void *arg));
void	realitexpire __P((void *));

struct clockframe;
int	hardclock __P((struct clockframe *frame));
void	pcpu_hardclock __P((int master, struct clockframe *frame));
void	softclock __P((void));
void	schedcpu __P((void *));

void	statclock __P((struct clockframe *frame, int firstcpu));

void	initclocks __P((void));

void	startprofclock __P((struct proc *));
void	stopprofclock __P((struct proc *));
void	setstatclockrate __P((int hzrate));

/*
 * atshutdown: schedule a function to be called as the system shuts down.
 * Like libc atexit, except that caller provides storage in the form
 * of an atshutdown structure.
 */
struct atshutdown {
	void	(*func) __P((void *));
	void	*arg;
	struct	atshutdown *next;
};

/* the second argument of atshutdown() */
#define ATSH_ADD      0
#define ATSH_REMOVE   1

void	atshutdown __P((struct atshutdown *, int));
void	doatshutdown __P((void));

/*
 * wayout: schedule a function to be called as soon as interrupts are
 * re-enabled.  It is an error to call wayout() with a wayout structure
 * that has already been scheduled.
 */
struct wayout {
	void	(*func) __P((void *));	/* set by caller */
	void	*arg;			/* set by caller */
	struct	wayout *next;		/* used by wayout */
	int	pending;		/* set by wayout, cleared by func */
};

void	wayout __P((struct wayout *));
void	dowayout __P((void));

/*
 * One time package initialization.  Execute the specified function
 * at most one time.  Can be used to auto-initialize upper half kernel
 * modules.  The static initializer ONCECONTROL_INITIALIZER provides a
 * way for the caller to initialize the onceinit lock to a known state
 * and get around the obvious chicken/egg problem.
 */

typedef struct {
	unsigned int ol_lock : 1;
	unsigned int ol_want : 1;
	unsigned int ol_inited : 1;
} oncecontrol_t;

#define	ONCECONTROL_INITIALIZER 	{ 0 }

void 	onceinit __P((oncecontrol_t *, void (*)(void)));

#include <common/libkern.h>

#endif /* !_SYS_SYSTM_H_ */
