/*	BSDI tty.h,v 2.7 2001/03/06 16:22:34 giff Exp	*/

/*-
 * Copyright (c) 1982, 1986, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)tty.h	8.7 (Berkeley) 1/9/95
 */

#ifndef _SYS_TTY_H_
#define _SYS_TTY_H_

#include <sys/termios.h>
#include <sys/ttystats.h>
#include <sys/select.h>		/* For struct selinfo. */

/*
 * "Clists" are a description of a character queue, including 
 * the number of characters in the list, the size of the queue, and
 * references to the data for use by the clist manipulation routines.
 */
struct clist {
	int	c_cc;		/* count of characters in queue */
	int	c_cs;		/* size of queue */
	char	*c_cf;		/* first character in queue */
	char	*c_cl;		/* last chararacter in queue */
	char	*c_cq;		/* the queue itself */
	char	*c_ce;		/* ptr to end of the queue */
	char 	*c_ct;		/* quote bits for c_cq */
	int	c_quotes;	/* number of quote bits set */
};

/*
 * tty state and statistics visible externally
 */
struct ttystat {
	dev_t	ts_dev;			/* Device */
	int	ts_rawqcc;		/* Device raw input queue count */
	int	ts_canqcc;		/* Device canonical queue count */
	int	ts_outqcc;		/* Device output queue count */
	u_long	ts_rawcc;		/* Raw input total */
	u_long	ts_cancc;		/* Canonical total */
	u_long	ts_outcc;		/* Output total */
	int	ts_line;		/* Line discipline */
	int	ts_state;		/* Device and driver (TS*) state */
	pid_t	ts_pgid;		/* Foreground process group */
	struct	session *ts_session;	/* Enclosing session */
	short	ts_column;		/* tty output column */
	short	ts_hiwat;		/* High water mark */
	short	ts_lowat;		/* Low water mark */
	short	ts_sspare;		/* padding */
	long	ts_spare[3];		/* future expansion */
};

/*
 * Per-tty structure.
 *
 * Should be split; includes components used by generic tty layer,
 * line disciplines and device driver.
 */
struct tty {
	struct	clist t_rawq;		/* Device raw input queue */
	struct	clist t_canq;		/* Device canonical queue */
	struct	clist t_outq;		/* Device output queue */
	struct	ttystat t_stat;		/* externally visible state/stats */
	int	t_flags;		/* tty_compat, saved flags */
	struct	pgrp *t_pgrp;		/* Foreground process group */
	struct	selinfo t_rsel;		/* tty read/oob select */
	struct	selinfo t_wsel;		/* tty write select */
	struct	termios t_termios;	/* Termios state */
	struct	winsize t_winsize;	/* Window size */
					/* Start output */
	void	(*t_oproc) __P((struct tty *));
					/* Stop output */
	void	(*t_stop) __P((struct tty *, int));
					/* Set hardware state */
	int	(*t_param) __P((struct tty *, struct termios *));
					/* block input function */
	void	(*t_blockin) __P((struct tty *, u_char *, int));
	void	*t_sc;			/* line discipline private data */
	void	*t_driver;		/* driver private data */
	short	t_rocount, t_rocol;	/* tty/ttydesc private */
	short	t_gen;			/* Generation number */
};

#define	t_dev		t_stat.ts_dev
#define	t_rawcc		t_stat.ts_rawcc
#define	t_cancc		t_stat.ts_cancc
#define	t_outcc		t_stat.ts_outcc
#define	t_line		t_stat.ts_line
#define	t_state		t_stat.ts_state
#define	t_session	t_stat.ts_session
#define	t_column	t_stat.ts_column
#define	t_hiwat		t_stat.ts_hiwat
#define	t_lowat		t_stat.ts_lowat

#define	t_cc		t_termios.c_cc
#define	t_cflag		t_termios.c_cflag
#define	t_iflag		t_termios.c_iflag
#define	t_ispeed	t_termios.c_ispeed
#define	t_lflag		t_termios.c_lflag
#define	t_min		t_termios.c_min
#define	t_oflag		t_termios.c_oflag
#define	t_ospeed	t_termios.c_ospeed
#define	t_time		t_termios.c_time

#define	TTIPRI	25			/* Sleep priority for tty reads. */
#define	TTOPRI	26			/* Sleep priority for tty writes. */

#define	TTMASK	15
#define	OBUFSIZ	100

#define	TTYHOG		4096		/* input/output buffer size/limit */
#define	TTYBLOCK	3584		/* point at which to stop input */
#define	TTYUNBLOCK	2048		/* point at which to resume input */

#ifdef KERNEL
#define TTYSLOP 	100		/* extra chars to allow uprintf */
#define TTMAXHIWAT	(TTYHOG - TTYSLOP - 4)
#define TTMINHIWAT	100
#define	TTMAXLOWAT	256
#define	TTMINLOWAT	32
#endif

/* These flags are kept in t_state. */
#define	TS_ASLEEP	0x00001		/* Process waiting for tty lowat. */
#define	TS_ASYNC	0x00002		/* tty in async I/O mode. */
#define	TS_BUSY		0x00004		/* Draining output. */
#define	TS_CARR_ON	0x00008		/* Carrier is present. */
#define	TS_FLUSH	0x00010		/* Outq has been flushed during DMA. */
#define	TS_ISOPEN	0x00020		/* Open has completed. */
#define	TS_TBLOCK	0x00040		/* Further input blocked. */
#define	TS_TIMEOUT	0x00080		/* Wait for output char processing. */
#define	TS_TTSTOP	0x00100		/* Output paused. */
#define	TS_WOPEN	0x00200		/* Open in progress. */
#define	TS_XCLUDE	0x00400		/* tty requires exclusivity. */

/* State for intra-line fancy editing work. */
#define	TS_BKSL		0x00800		/* State for lowercase \ work. */
#define	TS_CNTTB	0x01000		/* Counting tab width, ignore FLUSHO. */
#define	TS_ERASE	0x02000		/* Within a \.../ for PRTRUB. */
#define	TS_LNCH		0x04000		/* Next character is literal. */
#define	TS_TYPEN	0x08000		/* Retyping suspended input (PENDIN). */
#define	TS_LOCAL	(TS_BKSL | TS_CNTTB | TS_ERASE | TS_LNCH | TS_TYPEN)

#define	TS_RWAIT	0x10000		/* reader is sleeping for input */
#define	TS_LOCK		0x20000		/* tty locked while changing queues */
#define	TS_XON_PEND	0x40000		/* XON must be sent */
#define	TS_XOFF_PEND	0x80000		/* XOFF must be sent */
#define	TS_ESLEEP	0x100000	/* Process waiting for tty empty. */

/* Character type information. */
#define	ORDINARY	0
#define	CONTROL		1
#define	BACKSPACE	2
#define	NEWLINE		3
#define	TAB		4
#define	VTAB		5
#define	RETURN		6

struct speedtab {
	int sp_speed;			/* Speed. */
	int sp_code;			/* Code. */
};

/* Modem control commands (driver). */
#define	DMSET		0
#define	DMBIS		1
#define	DMBIC		2
#define	DMGET		3

/* Flags on a character passed to ttyinput. */
#define	TTY_CHARMASK	0x000000ff	/* Character mask */
#define	TTY_QUOTE	0x00000100	/* Character quoted */
#define	TTY_ERRORMASK	0xff000000	/* Error mask */
#define	TTY_FE		0x01000000	/* Framing error or BREAK condition */
#define	TTY_PE		0x02000000	/* Parity error */

/* Is tp controlling terminal for p? */
#define	isctty(p, tp)							\
	((p)->p_session == (tp)->t_session && (p)->p_flag & P_CONTROLT)

/* Is p in background of tp? */
#define	isbackground(p, tp)						\
	(isctty((p), (tp)) && (p)->p_pgrp != (tp)->t_pgrp)

#ifdef KERNEL
extern	struct termios deftermios;

/* Symbolic sleep message strings. */
extern	 char ttyin[], ttyout[], ttopen[], ttclos[], ttybg[], ttybuf[];

void	 cqttyinit __P(( struct tty *tp, int size));
void	 cqttydestroy __P((struct tty *tp));

int	 b_to_q __P((char *cp, int cc, struct clist *q));
void	 catq __P((struct clist *from, struct clist *to));
int	 getc __P((struct clist *q));
void	 ndflush __P((struct clist *q, int cc));
int	 ndqb __P((struct clist *q, int flag));
u_char	*getcblk __P((struct clist *qp, int *retp));
char	*nextc __P((struct clist *q, char *cp, int *c));
int	 putc __P((int c, struct clist *q));
int	 q_to_b __P((struct clist *q, char *cp, int cc));
int	 unputc __P((struct clist *q));

int	 nullmodem __P((struct tty *tp, int flag));
int	 tputchar __P((int c, struct tty *tp));
int	 ttioctl __P((struct tty *tp, u_long com, void *data, int flag,
	    struct proc *p));
int	 ttread __P((struct tty *tp, struct uio *uio, int flag));
void	 ttrstrt __P((void *tp));
int	 ttselect __P((dev_t device, int rw, struct proc *p));
void	 ttsetwater __P((struct tty *tp));
int	 ttspeedtab __P((int speed, struct speedtab *table));
int	 ttstart __P((struct tty *tp));
void	 ttwakeup __P((struct tty *tp));
int	 ttwrite __P((struct tty *tp, struct uio *uio, int flag));
void	 ttyblockin __P((struct tty *tp, u_char *, int));
void	 ttychars __P((struct tty *tp));
int	 ttycheckoutq __P((struct tty *tp, int wait));
int	 ttyclose __P((struct tty *tp));
void	 ttyflush __P((struct tty *tp, int rw));
void	 ttyinfo __P((struct tty *tp));
void	 ttyinput __P((int c, struct tty *tp));
int	 ttylclose __P((struct tty *tp, int flag));
int	 ttymodem __P((struct tty *tp, int flag));
int	 ttyopen __P((dev_t device, struct tty *tp));
int	 ttyoutput __P((int c, struct tty *tp));
void	 ttypend __P((struct tty *tp));
void	 ttyrawblockin __P((struct tty *tp, u_char *, int));
void	 ttyretype __P((struct tty *tp));
void	 ttyrub __P((int c, struct tty *tp));
int	 ttysleep __P((struct tty *tp,
	    void *chan, int pri, char *wmesg, int timeout));
void	 ttyowake __P((struct tty *tp));
int	 ttywait __P((struct tty *tp));
int	 ttywflush __P((struct tty *tp));
#endif

#endif /* !_SYS_TTY_H_ */
