#!/bin/csh -fb
# (The "-fb" might need to be changed to "-f" on some systems)
#
#
# This is sun-message.  It looks at $2 to figure out how to decode $1, then gives the
# user a short menu of choices, display, save, or quit.
#
mkdir -m 0700 /tmp/decode.$$ || exit 1
cd /tmp/decode.$$ || exit 1

if (${2:q} == "uuencode") then
    uudecode ${1:q}

    echo "The following file was uudecoded:"
    echo ""

    set defans = "1"
    while (1)
	ls -l
	set fn = *

	echo ""
	echo "Please choose one:"
	echo ""
	echo "1 -- Display it as ASCII text"
	echo "2 -- Save it as a file"
	echo "3 -- Quit this menu"
	echo ""
	echo -n "Which do you prefer (1 - 3)? [${defans:q}] "

	set ans = $< 
	if (${ans:q} == "") then
	    set ans = ${defans:q}
	endif
	if (${ans:q} == 3)  then
	    rm ${1:q}
	    cd /tmp; /bin/rm -rf /tmp/decode.$$
	    exit 0
	else if (${ans:q} == 1) then
	    more ${fn:q}
	else if (${ans:q} == 2) then
	    set nfn = ""
	    echo -n "Save as: ${HOME:q}/"
	    set nfn = $<
	    if (${nfn:q} != "") then
		/bin/cp ${fn:q} ${HOME:q}/${nfn:q}
	    else
		echo "Not Saved."
	    endif
	else
	    echo "Invalid choice."
	endif
	set defans = "3"
    end
else
    more ${1:q}
endif


