#include <Cvo/Application.h++>
#include <Cvo/Label.h++>
#include <Cvo/Separator.h++>
#include <Cvo/Window.h++>

// Set these X resource values.

Cvo_Default def[] = {
    "*Window.labelOne.label: Label One",
    "*Window.labelTwo.label: Label Two"
};

main(int argc, char **argv)
{
    Cvo_Parse(&argc, &argv);	// Parse the command line arguments.

    // Create an application root object, and then put a window
    // object in the application window to give it a raised
    // appearance.

    Cvo_Application *app = new Cvo_Application("exampleApp");

    Cvo_Window *win = new Cvo_Window("appWin", app);
    win->VerticalChildren();

    // Create two labels and a separator between them. They take
    // their labels from X resources.

    new Cvo_Label("labelOne", win, "NR");
    new Cvo_Separator(win);
    new Cvo_ChamferedLabel("labelTwo", win, "NR");

    app->MainLoop();
}
