/*
 *
 * Create a Cvo_PinUp object as the root object.
 *
 */

#include <Cvo/Label.h++>
#include <Cvo/PinUp.h++>

// Set some label text resources.

static Cvo_Default def[] = {
    "*CvoFrame.CvoLabel.label: Example PinUp",
    "*label1.label: Label One",
    "*label2.label: Label Two"
};

void DestroyedHandler(Cvo_Object *, XEvent *, void *);

main(int argc, char **argv)
{
    // Parse the command line arguments.

    Cvo_Parse(&argc, &argv);

    // Create Cvo_PinUp object, with a resource name of Test.
    // As this is the initial object, it has no parent argument.
    // The pin of the Cvo_PinUp is initially pushed in.

    Cvo_PinUp *pinup = new Cvo_PinUp("example");
    pinup->Pinned(True);

    // When the pin is pulled out, the pinup is destroyed.
    // Register this event so the program will exit.

    Cvo_Register(pinup, CvoDestroyedEvent, DestroyedHandler);

    // Create two Cvo_Label objects, with the Cvo_Application
    // object as their parent.

    Cvo_ChamferedLabel *label1= new Cvo_ChamferedLabel("label1", pinup, "NR");
    Cvo_ChamferedLabel *label2= new Cvo_ChamferedLabel("label2", pinup, "NR");

    // Let X map the application and let the application
    // begin processing events.

    pinup->MainLoop();
}

void DestroyedHandler(Cvo_Object *, XEvent *, void *)
{
    Cvo_Exit(0);
}
