/*
 *
 * Create a Cvo_Application with a Cvo_Window as a child. This will
 * result in the children of the Cvo_Window being raised above the
 * Cvo_Application. This is one use of a Cvo_Window object, other than
 * deriving new objects from it.
 *
 */

#include <Cvo/Application.h++>
#include <Cvo/Button.h++>
#include <Cvo/Color.h++>
#include <Cvo/GenericList.h++>
#include <Cvo/InputViewPort.h++>
#include <Cvo/Page.h++>
#include <Cvo/Window.h++>

// Set default resources.

static Cvo_Default def[] = {
    "*fontSize: 14",
    "*winBack.buttonQuit.label: Quit",
    "*Background: lime green",
    "*Foreground: blue",
};

void Exposure(Cvo_Object *, XEvent *, void *);
void Destroyed(Cvo_Object *, XEvent *, void *);

main(int argc, char **argv)
{
    // Parse the command line arguments.

    Cvo_Parse(&argc, &argv);

    Cvo_Application *exampleApp = new Cvo_Application("exampleApp");

    // One use of a window is to give an application a raised look,
    // like this.

    new Cvo_GenericList("glist", exampleApp, new Cvo_TextPage());

    Cvo_InputViewPort *iv = new Cvo_InputViewPort("iv", exampleApp);
    iv->SetMinSize(0, 10);
    iv->ExpandFrame();

    Cvo_Window *winBack = new Cvo_Window("winBack", exampleApp);

    Cvo_Window *draw = new Cvo_Window("draw", winBack);
    draw->SetMinPixelSize(100, 100);
    draw->Register(Expose, Exposure);

    // Make a button which calls the Destroyed() function.

    Cvo_Button *buttonQuit = new Cvo_Button("buttonQuit", winBack, "NR");
    buttonQuit->ExpandFrame();

    Cvo_Register(buttonQuit, CvoButtonUpEvent, Destroyed);

    exampleApp->MainLoop();
}

void Exposure(Cvo_Object *obj, XEvent *, void *)
{
    Cvo_Window *win = (Cvo_Window *) obj;

    win->Flatten();
    win->DrawEtchedChamfer(5, 5, 5, 90, 90, Cvo_Color(win, "purple"));
    win->DrawDownArrow(15, 15, 30, 25);
}

void Destroyed(Cvo_Object *, XEvent *, void *)
{
    Cvo_Exit(0);
}
