#include <Cvo/Application.h++>
#include <Cvo/Button.h++>
#include <Cvo/Frame.h++>
#include <Cvo/Label.h++>

void Handler(Cvo_Object *, XEvent *, void *);

Cvo_Application *app;
Cvo_Frame *fr1;
Cvo_Label *label1;
Cvo_Label *label2;

main(int argc, char **argv)
{
    Cvo_Parse(&argc, &argv);

    app = new Cvo_Application("foo");

    fr1 = new Cvo_Frame(app);
    fr1->ExpandFrame();
    fr1->VerticalChildren();

    label1 = new Cvo_Label("label1", fr1, "Label One");
    label2 = new Cvo_Label("label2", fr1, "Label Two");

    Cvo_Button *b1 = new Cvo_Button("but", app, "Press Me");
    Cvo_Register(b1, CvoButtonUpEvent, Handler);

    app->MainLoop();
}

void Handler(Cvo_Object *, XEvent *, void *)
{
    app->LowerWindow();
    app->Flush();

    fprintf(stderr, "fr1: %s\n", ((Cvo_Object *) fr1->RootObject())->Class());
    fprintf(stderr, "label1: %s\n", ((Cvo_Object *) label1->RootObject())->Class());
    fprintf(stderr, "label2: %s\n", ((Cvo_Object *) label2->RootObject())->Class());

    sleep(5);

    app->RaiseWindow();
    app->Flush();
}
