/*	BSDI endian.big.h,v 2.3 1996/07/15 19:07:29 torek Exp	*/

/*
 * Copyright (c) 1987, 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)endian.h	8.1 (Berkeley) 6/11/93
 */

#ifndef _ENDIAN_H_
#define	_ENDIAN_H_

/*
 * Define the order of 32-bit words in 64-bit words.
 */
#define _QUAD_HIGHWORD	0
#define _QUAD_LOWWORD	1

#ifndef _POSIX_SOURCE
/*
 * Definitions for byte order, according to byte significance from low
 * address to high.
 */
#define	LITTLE_ENDIAN	1234	/* LSB first: i386, vax */
#define	BIG_ENDIAN	4321	/* MSB first: 68000, ibm, net */
#define	PDP_ENDIAN	3412	/* LSB first in word, MSW first in long */

#define	BYTE_ORDER	BIG_ENDIAN

#include <sys/types.h>
#include <sys/cdefs.h>

#ifndef INLINE_NTOH
__BEGIN_DECLS
/* host to/from "net" (big endian) */
u_int32m_t	htonl __P((u_int32m_t));
u_int16m_t	htons __P((u_int16m_t));
u_int32m_t	ntohl __P((u_int32m_t));
u_int16m_t	ntohs __P((u_int16m_t));
/* host to/from little endian */
u_int32m_t	htole32 __P((u_int32m_t));
u_int16m_t	htole16 __P((u_int16m_t));
u_int32m_t	letoh32 __P((u_int32m_t));
u_int16m_t	letoh16 __P((u_int16m_t));
__END_DECLS
#endif

/*
 * Macros for network/external number representation conversion.
 */
#if BYTE_ORDER == BIG_ENDIAN
#define	ntohl(x)	((u_int32m_t)(x))
#define	ntohs(x)	((u_int16m_t)(x))
#define	htonl(x)	((u_int32m_t)(x))
#define	htons(x)	((u_int16m_t)(x))

#define	NTOHL(x)	(x)
#define	NTOHS(x)	(x)
#define	HTONL(x)	(x)
#define	HTONS(x)	(x)

#define	HTOLE32(x)	(x) = htole32((u_int32m_t)x)
#define	HTOLE16(x)	(x) = htole16((u_int16m_t)x)
#define	LETOH32(x)	(x) = letoh32((u_int32m_t)x)
#define	LETOH16(x)	(x) = letoh16((u_int16m_t)x)

#else

#define	NTOHL(x)	(x) = ntohl((u_int32m_t)x)
#define	NTOHS(x)	(x) = ntohs((u_int16m_t)x)
#define	HTONL(x)	(x) = htonl((u_int32m_t)x)
#define	HTONS(x)	(x) = htons((u_int16m_t)x)

#define	htole32(x)	((u_int32m_t)(x))
#define	htole16(x)	((u_int16m_t)(x))
#define	letoh32(x)	((u_int32m_t)(x))
#define	letoh16(x)	((u_int16m_t)(x))

#define	HTOLE32(x)	(x)
#define	HTOLE16(x)	(x)
#define	LETOH32(x)	(x)
#define	LETOH16(x)	(x)
#endif
#endif /* !_POSIX_SOURCE */
#endif /* !_ENDIAN_H_ */
