/*
 * Copyright (c) 1997 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI kerntm.h,v 1.1 1997/10/01 02:51:59 torek Exp
 */

/*
 * Data structure and functions for converting the kernel time
 * format -- UTC seconds since 1970/1/1 -- to the forms used by
 * clock chips.
 *
 * Note that this is just a subset of a "struct tm"; perhaps we
 * should just use it directly.
 *
 * For consistency, we preserve the same quirks found in a "struct tm" --
 * e.g., tm_mday is 1-based but tm_mon is 0-based, and tm_year has 1900
 * subtracted.
 */
struct kerntm {
	/* the following fields are used for inputs */
	int	tm_sec;		/* seconds (0 - 59 -- no leap seconds) */
	int	tm_min;		/* minutes (0 - 59) */
	int	tm_hour;	/* hours (0 - 23) */
	int	tm_mday;	/* day of month (1 - 31) */
	int	tm_mon;		/* month of year (0 - 11) */
	int	tm_year;	/* year minus 1900 */

	/* ??? should we attempt DST at all? (currently we do not) */

	/* the remaining fields are outputs only */
	int	tm_wday;	/* day of week (Sunday = 0) */
	int	tm_yday;	/* day of year (0 - 365) */
};

/* N.B.: kerntm_to_time will return 0 if the input looks invalid */
time_t	kerntm_to_time __P((struct kerntm *));
void	time_to_kerntm __P((struct kerntm *, time_t));
