/*	BSDI param.c,v 2.25.2.1 2001/04/24 00:11:37 peer Exp */

/*
 * Copyright (c) 1980, 1986, 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)param.c	8.2 (Berkeley) 1/21/94
 */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/proc.h>
#include <sys/vnode.h>
#include <sys/file.h>
#include <sys/mbuf.h>
#include <sys/kernel.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <sys/msg.h>

#include <net/if.h>

#include <ufs/ufs/quota.h>

#include <vm/vm_param.h>

/*
 * System parameter formulae and other configuration-dependent information.
 *
 * This file is copied into each directory where we compile
 * the kernel; it should be modified there to suit local taste
 * if necessary.
 *
 * Compiled with -DHZ=xx -DTIMEZONE=x -DDST=x -DMAXUSERS=xx
 */

#ifndef HZ
#define	HZ 100
#endif
#ifndef TIMEZONE
#define TIMEZONE 0
#endif
#ifndef DST
#define DST 0
#endif
int	hz = HZ;
int	tick = 1000000 / HZ;
int	tickadj = 150000 / (60 * HZ);		/* can adjust 150ms in 60s */
struct	timezone tz = { TIMEZONE, DST };
int	maxusers = MAXUSERS;
#if MAXUSERS != 0
#define	NPROC (20 + 16 * MAXUSERS)
int	maxproc = NPROC;
#define	NTEXT (80 + NPROC / 8)			/* actually the object cache */
#define	NVNODE (NPROC * 2 + NTEXT + 100)
int	desiredvnodes = NVNODE;
int	maxfiles = 3 * (NPROC + MAXUSERS) + 80;
#undef NTEXT
#undef NVNODE
#else
int	maxproc = 0;
int	desiredvnodes = 0;
int	maxfiles = 0;
#endif /* MAXUSERS */
int	maxsymlinks = MAXSYMLINKS;
int	child_max = CHILD_MAX;	/* default cur limit, processes per user */
int	open_max = OPEN_MAX;	/* default cur limit, open files per user */
int	arg_max = ARG_MAX;	/* max arg list size for exec */
int	cmask = CMASK;
#ifdef INSECURE
int	securelevel = -1;	/* do not go to secure mode automatically */
#endif
#ifndef AUTONICETIME
#define	AUTONICETIME	10 * 60		/* in sec: 10 minutes of CPU time */
#endif
int autonicetime = AUTONICETIME;	/* time before automatic renice */

unsigned int	dfldsiz = DFLDSIZ;
unsigned int	maxdsiz = MAXDSIZ;
unsigned int	dflssiz = DFLSSIZ;
unsigned int	maxssiz = MAXSSIZ;

#ifndef SOMAXCONN
#define	SOMAXCONN	SOMAXCONN_DFLT
#endif
#ifndef MAXMBCLUSTERS
#define	MAXMBCLUSTERS	0		/* default is dynamic */
#endif
int	somaxconn = SOMAXCONN;
int	sb_max = SB_MAX;
int	nmbclusters = NMBCLUSTERS;	/* current/"soft" limit */
int	maxmbclusters = MAXMBCLUSTERS;	/* hard limit */
int	fscale = FSCALE;	/* kernel uses `FSCALE', user uses `fscale' */
int	userpriority = PUSER;	/* sysctl settable value for base user
				   priority. Defaults to PUSER */
int	rtmaxpriority = PRTMAX;	/* sysctl settable value for real-time max
				   priority. Defaults to PRTMAX */
#ifndef	IFQMAXLEN
#define	IFQMAXLEN	IFQ_MAXLEN
#endif
int	ifqmaxlen = IFQMAXLEN;
int	maxmapentries = MAXMAPENTRIES;

/*
 * Values in support of System V compatible shared memory.	XXX
 */
#ifndef SHMMAX
#define	SHMMAX	(SHMMAXPGS*PAGE_SIZE)
#endif
#ifndef SHMMIN
#define	SHMMIN	1
#endif
#ifndef SHMMNI
#define	SHMMNI	32			/* <= SHMMMNI in shm.h */
#endif
#ifndef SHMSEG
#define	SHMSEG	8
#endif
#ifndef SHMALL
#define	SHMALL	(SHMMAXPGS)
#endif
struct	shminfo shminfo = {
	SHMMAX,
	SHMMIN,
	SHMMNI,
	SHMSEG,
	SHMALL
};

/*
 * Values in support of System V compatible semaphores.
 */
struct seminfo seminfo = {
	SEMMAP,         	/* # of entries in semaphore map */
	SEMMNI,         	/* # of semaphore identifiers */
	SEMMNS,         	/* # of semaphores in system */
	SEMMNU,         	/* # of undo structures in system */
	SEMMSL,         	/* max # of semaphores per id */
	SEMOPM,         	/* max # of operations per semop call */
	SEMUME,         	/* max # of undo entries per process */
	SEMUSZ,         	/* size in bytes of undo structure */
	SEMVMX,         	/* semaphore maximum value */
	SEMAEM          	/* adjust on exit max value */
};      

/*
 * Values in support of System V compatible messages.
 */
struct msginfo msginfo = {
                MSGMAX,         /* max chars in a message */
                MSGMNI,         /* # of message queue identifiers */
                MSGMNB,         /* max chars in a queue */
                MSGTQL,         /* max messages in system */
                MSGSSZ,         /* size of a message segment */
                		/* (must be small power of 2 greater than 4) */
                MSGSEG          /* number of message segments */
};

#ifndef BUFMEM
#define	BUFMEM	0		/* dynamically chosen based on physmem */
#endif
int	maxbufmem = BUFMEM;	/* maxbufmem in bytes */

#ifndef KMEMSIZE
#ifndef NKMEMCLUSTERS	/* compat with old systems, options NKMEMCLUSTERS */
#define	NKMEMCLUSTERS	0	/* dynamic, depending on memory size */
#endif
#define	KMEMSIZE	(NKMEMCLUSTERS * CLBYTES)
#endif
#define	MINKMEMSIZE	(2048*1024)

int	kmemsize = KMEMSIZE;	/* basic malloc arena size */

#define	KMAPENTRIES_DFLT	500
#ifndef KMAPENTRIES
#define	KMAPENTRIES		0		/* scale with memory */
#endif
int	max_kmapentries = KMAPENTRIES;

#define	pgtomb(m)	(((m) * NBPG) / (1024 * 1024))

/*
 * Called from main to set parameters dynamically.
 * May also be called earlier from machine-dependent code,
 * so must be safe to be called multiple times.
 * Must be called before kmeminit and vm_page_startup.
 */
set_params()
{
	int mb = pgtomb(physmem);

	/*
	 * If maxusers was not set, set one per MB of memory,
	 * as long as the value is between 10 and 128.
	 * Note, with I/O memory and msgbuf, mb gets rounded down.
	 */
	if (maxusers == 0) {
		if (mb < 16)
			maxusers = 10;
		else
			maxusers = max(10, min(mb - 16, 128));
	}
	if (maxproc == 0)
		maxproc = 20 + 16 * maxusers;
#define	NTEXT (80 + maxproc / 8)		/* actually the object cache */
#define	NVNODE (maxproc * 2 + NTEXT + 100)
	if (desiredvnodes == 0)
		desiredvnodes = NVNODE;
	if (maxfiles == 0)
		maxfiles = 3 * (maxproc + maxusers) + 80;
	if (kmemsize == 0) {
		kmemsize = MINKMEMSIZE;
		/*
		 * If physical memory is > 32 MB, add 1 MB of kernel/kmem space
		 * for each additional 16 MB of real memory, hitting 4 MB
		 * at 64 and 8 MB at 128, more or less as this worked
		 * in the past (but driven from maxusers as a step function).
		 */
		if (mb > 32)
		    kmemsize +=
			roundup((physmem * NBPG - 32 * 1024 * 1024) / 16, NBPG);
	}
	if (max_kmapentries == 0) {
		/* up to MINKMEMSIZE, use KMAPENTRIES_DFLT; scale above that */
		if (kmemsize <= MINKMEMSIZE)
			max_kmapentries = KMAPENTRIES_DFLT;
		else
			max_kmapentries = KMAPENTRIES_DFLT *
			    (kmemsize / 1024) / (MINKMEMSIZE / 1024);
	}
	/* Sanity.  */
	maxdsiz = FIX_MAXDSIZ(maxdsiz);
	maxssiz = FIX_MAXSSIZ(maxssiz);
}

/*
 * These are initialized at bootstrap time
 * to values dependent on memory size
 */
int	nswbuf;

struct	buf *swbuf;

#ifdef FORK_WAIT
int	fork_wait = 3;		/* delay child 3 ticks after fork */
#else
int	fork_wait = 0;		/* do not delay child after fork */
#endif

#ifdef NFS
#ifdef NFS_SERV_ASYNC
int nfs_serv_async = 1;
#else
int nfs_serv_async = 0;
#endif
#else  /* NFS */

/*
 * dummy NFS lock routine to satisfy references from a binary kernel
 * compiled w/o NFS.
 */
void
nlminfo_release(p)
	struct proc *p;
{
}
#endif /* NFS */

#include "bpfilter.h"
#if NBPFILTER == 0
/*
 * dummy bpf routines to satisfy driver references
 * if bpf is not configured.
 */

void
bpfattach(driverp, ifp, dlt, hdrlen)
	caddr_t *driverp;
	struct ifnet *ifp;
	u_int dlt, hdrlen;
{
}

void
bpf_tap(arg, pkt, pktlen)
	caddr_t arg;
	u_char *pkt;
	u_int pktlen;
{
}

void
bpf_mtap(arg, m)
	caddr_t arg;
	struct mbuf *m;
{
}
#endif /* NBPFILTER == 0 */

#ifdef KTR
#include <sys/ktr.h>
#ifndef KTR_MASK
#define	KTR_MASK ~0
#endif
int ktr_mask = KTR_MASK;
int ktr_size = KTR_SIZE;
int ktr_size_mask = KTR_SIZE - 1;
#else
/* For binary kernels */
int ktr_mask;	/* 0 */
int ktr_size;	/* 0 */
int ktr_size_mask;
#endif

#ifdef UNION
#ifndef NULLFS
int (**null_vnodeop_p)() = (int (**)())0;
#endif

#ifndef UMAPFS
int (**umap_vnodeop_p)() = (int (**)())0;
#endif
#else
int
union_nextdir()
{
	return (0);
}
#endif

/* This should be in dev/disk_subr.c but it is used at other places */
struct dkdevice *diskhead;

