/*
 *
 * ===================================
 * HARP  |  Host ATM Research Platform
 * ===================================
 *
 *
 * Copyright (c) 1996-1998, Network Computing Services, Inc.
 * All rights reserved.
 *
 *	@(#) eni_var.h,v 1.4 1998/06/29 19:55:26 jpt Exp
 *
 */

/*
 * Efficient ENI Adapter Support
 * -----------------------------
 *
 * Local driver include files and global declarations
 *
 */

#ifndef	_ENI_ENI_VAR_H
#define	_ENI_ENI_VAR_H

/*
 * Global function declarations
 */
	/* eni_buffer.c */
int	eni_init_memory __P((Eni_unit *));
caddr_t	eni_allocate_buffer __P((Eni_unit *, u_long *));
void	eni_free_buffer __P((Eni_unit *, caddr_t));

	/* eni_if.c */
int	eni_atm_ioctl __P((int, caddr_t, caddr_t));
void	eni_zero_stats __P((Eni_unit *));

	/* eni_init.c */
int	eni_init __P((Eni_unit *));

	/* eni_intr.c */
#if defined(BSD) && BSD < 199506
int	eni_intr __P((void *));
#else
void	eni_intr __P((void *));
#endif

	/* eni_receive.c */
void	eni_do_service __P((Eni_unit *));
void	eni_recv_drain __P((Eni_unit *));

	/* eni_transmit.c */
int	eni_set_dma __P((Eni_unit *, int, u_long *, int, long *, int, u_long, int ));
void	eni_output __P((Cmn_unit *, Cmn_vcc *, KBuffer *));
void	eni_xmit_drain __P((Eni_unit *));

	/* eni_vcm.c */
int	eni_instvcc __P((Cmn_unit *, Cmn_vcc *));
int	eni_openvcc __P((Cmn_unit *, Cmn_vcc *));
int	eni_closevcc __P((Cmn_unit *, Cmn_vcc *));

/*
 * Global variable declarations
 */
extern Eni_unit		*eni_units[];
extern struct stack_defn	*eni_services;
extern struct sp_info	eni_nif_pool;
extern struct sp_info	eni_vcc_pool;

#endif	/* _ENI_ENI_VAR_H */
