/*
 *
 * ===================================
 * HARP  |  Host ATM Research Platform
 * ===================================
 *
 *
 * Copyright (c) 1994-1997, Network Computing Services, Inc.
 * All rights reserved.
 *
 *	@(#) fore_stats.h,v 1.3 1997/05/06 22:10:21 mks Exp
 *
 */

/*
 * FORE Systems 200-Series Adapter Support
 * ---------------------------------------
 *
 * Driver statistics definitions
 *
 */

#ifndef _FORE_STATS_H
#define _FORE_STATS_H


/*
 * Fore Driver Statistics
 */
struct Stats_driver {
	u_long		drv_xm_notact;	/* PDU drops out - VCC not active */
	u_long		drv_xm_full;	/* Xmit queue full */
	u_long		drv_xm_maxpdu;	/* PDU drops out - max segment/size */
	u_long		drv_xm_segnoal;	/* Non-aligned segments */
	u_long		drv_xm_seglen;	/* Padded length segments */
	u_long		drv_xm_segdma;	/* PDU drops out - no dma address */
	u_long		drv_rv_novcc;	/* PDU drops in - no VCC */
	u_long		drv_rv_nosbf;	/* No small buffers */
	u_long		drv_rv_nomb;	/* PDU drops in - no buffer */
	u_long		drv_rv_ifull;	/* PDU drops in - intr queue full */
	u_long		drv_bf_segdma;	/* Buffer supply - no dma address */
	u_long		drv_cm_full;	/* Command queue full */
	u_long		drv_cm_nodma;	/* Command failed - no dma address */
};
typedef struct Stats_driver	Stats_driver;


/*
 * Fore Device Statistics
 *
 * This structure is used by pass all statistics (including CP maintained 
 * and driver maintained) data to user space (atm command).
 */
struct fore_stats {
	Fore_cp_stats	st_cpstat;	/* CP stats */
	Stats_driver	st_drv;		/* Driver maintained stats */
};
typedef struct fore_stats	Fore_stats;

#define	st_taxi		st_cpstat.st_cp_taxi
#define	st_oc3		st_cpstat.st_cp_oc3
#define	st_atm		st_cpstat.st_cp_atm
#define	st_aal0		st_cpstat.st_cp_aal0
#define	st_aal4		st_cpstat.st_cp_aal4
#define	st_aal5		st_cpstat.st_cp_aal5
#define	st_misc		st_cpstat.st_cp_misc

#endif	/* _FORE_STATS_H */
