/* Copyright (c) 1996 Berkeley Software Design Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI bcm5000.h,v 1.1 1998/05/02 01:35:28 geertj Exp
 */

#ifndef _BCM5000_H_
#define _BCM5000_H_

/*
 * Defines for Broadcomm Corporation BCM5000 100baseT4 Transceiver
 *
 * Note: the bulk of the registers are defined in mii.h.
 */

#define	BCM5000_OUI		0x00f800
#define	BCM5000_MODEL	0		/* BCM5000 */

/* PHY specific registers */
#define	MII_EX0		0x10	/* Extended register 0 */
#define	MII_EX1		0x14	/* Extended register 1 */

/* EX0 bits */
#define	EX0_JABDIS	0x8000	/* RW: Jabber function disable */
#define	EX0_LINKDIS	0x4000	/* RW: Link integrety test disable */
#define	EX0_FORCEFAIL_EN 0x0100	/* RW: Force fail enable XXX??? */
#define	EX0_REV_CNTR	0x0070	/* RO: Revision control indicator */
#define	EX0_SQ		0x0018	/* RW: Squelch mode */
#define	EX0_TXDAC	0x0004	/* RW: Keep TX DACs powered during idle */
#define	EX0_SPEED	0x0002	/* RO: 1=100Mbps, 0=10Mbps */

/* EX1 bits */
#define	EX1_SKEWERR	0x8000	/* RO: Pair skew error */
#define	EX1_DCBALERR	0x4000	/* RO: DC balance error */
#define	EX1_INVCODE	0x2000	/* RO: Invalid code error */
#define	EX1_BADCODE	0x1000	/* RO: Bad code error */
#define	EX1_EOPERR	0x0800	/* RO: EOP error */
#define	EX1_MANCHERR	0x0400	/* RO: Manchester code error */
#define	EX1_EOFERR	0x0200	/* RO: Channel 2 EOFcode error */

#endif /* !_BCM5000_H_ */
